% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_fields.R
\name{search_fields}
\alias{search_fields}
\title{Query layers, fields or assertions by free text search}
\usage{
search_fields(query, type = "all")
}
\arguments{
\item{query}{\code{string}: A search string. Not case sensitive.}

\item{type}{\code{string}: What type of parameters should be searched?
Should be one or more of \code{fields}, \code{layers}, \code{assertions},
\code{media} or \code{all}.}
}
\value{
A \code{data.frame} with three columns:
\itemize{
 \item{id: The identifier for that layer or field. This is the value that should
 be used when referring to a field in another function.}
 \item{description: Detailed information on a given field}
 \item{type: Whether the field is a \code{field} or \code{layer}}
 \item{link: For layers, a link to the source data (if available)}
}
}
\description{
This function can be used to find relevant fields and/or layers
for use in building a set of filters with \code{\link{select_filters}()} or
specifying required columns with \code{\link{select_columns}()}.
This function returns a \code{data.frame} of all fields matching the type
specified.
Field names are in Darwin Core format, except in the case where the field is
specific to the ALA database, in which case the ALA field name is returned.
}
\details{
Layers are the subset of fields that are spatially appended to each record
by the ALA. Layer ids are comprised of a prefix: 'el' for environmental
(gridded) layers and 'cl' for contextual (polygon) layers,  followed by an
id number.
}
\examples{
\dontrun{
test <- search_fields("species")

# Find all WorldClim layers
worldclim <- search_fields("worldclim", type = "layers")

# Return a data.frame containing all data on fields and layers
all_fields <- search_fields()
}
}
\references{
\itemize{
\item Darwin Core terms \url{https://dwc.tdwg.org/terms/}
\item ALA fields \url{https://api.ala.org.au/#ws72}
\item ALA assertions fields \url{https://api.ala.org.au/#ws81}
}
}
\seealso{
This function is used to pass valid arguments to
\code{\link{select_columns}()} and \code{\link{select_filters}()}.
To view valid values for a layer with categorical values, use
\code{\link{find_field_values}()}.
}
