#' A data frame of an acrylic degradation experiment
#' 
#' This data set is a study of photodegradation of acrylic polymers. In this work, polymeric samples were exposed to different levels of light exposures and resulting optical changes were determined through optical spectroscopy. *IrradTot* (total applied irradiance) is the main predictor (or stressor in this data) and *YI* (yellowness index) is the performance level response. The other columns in the data set (*IAD1*, *IAD2*, *IAD2p*, and *IAD3*)  are induced absorbency to dose values extracted from optical absorbency spectra as single metrics and used as intermediate unit level response variables in the gSEM analysis.
#' 
#' @docType data
#' @keywords datasets
#' @format A 357 by 6 data frame of continuous variables.
#' @name acrylic
NULL
