% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-utilities.R
\name{graph-randomdag}
\alias{graph-randomdag}
\alias{random_dag}
\title{Random directed acyclic graph}
\usage{
random_dag(V, maxpar = 3, wgt = 0.1)
}
\arguments{
\item{V}{The set of vertices.}

\item{maxpar}{The maximum number of parents each node can have}

\item{wgt}{A parameter controlling how likely it is for a node to
have a certain number of parents; see 'Details'.}
}
\value{
A graphNEL object.
}
\description{
Generate a random directed acyclic graph (DAG)
}
\details{
If the maximum number of parents for a node is, say 3 and
wgt=0.1, then the probability of the node ending up with
0,1,2,3 parents is proportional to 0.1^0, 0.1^1, 0.1^2, 0.1^3.
}
\examples{
dg   <- random_dag(1:1000, maxpar=5, wgt=.9)
table(sapply(vpar(dg),length))

dg   <- random_dag(1:1000, maxpar=5, wgt=.5)
table(sapply(vpar(dg),length))

dg   <- random_dag(1:1000, maxpar=5, wgt=.1)
table(sapply(vpar(dg),length))

}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
