% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t_array_create.R
\name{array-create}
\alias{array-create}
\alias{tab}
\alias{ar_new}
\title{Create multidimensional arrays}
\usage{
ar_new(names, levels, values, normalize = "none", smooth = 0)
}
\arguments{
\item{names}{Names of variables defining table; a character vector
or a right hand sided formula.}

\item{levels}{1) a list with specification of the levels of the
factors in \code{names} or 2) a vector with number of levels of
the factors in \code{names}. See 'examples' below.}

\item{values}{values to go into the parray}

\item{normalize}{Either "none", "first" or "all". Should result be
normalized, see 'Details' below.}

\item{smooth}{Should values be smoothed, see 'Details' below.}
}
\value{
An array.
}
\description{
Alternative ways of creating arrays
}
\details{
If \code{normalize="first"} then for each configuration of
    all other variables than the first, the probabilities are
    normalized to sum to one.  Thus f(a,b,c) becomes a conditional
    probability table of the form p(a|b,c).  If
    \code{normalize="all"} then the sum over all entries of
    f(a,b,c) is one.

    If \code{smooth} is positive then
    \code{smooth} is added to \code{values} before normalization
    takes place.
}
\examples{

universe <- list(gender=c('male','female'),
                 answer=c('yes','no'),
                 rain=c('yes','no'))
t1 <- ar_new(c("gender","answer"), levels=universe, values=1:4)
t1
t2 <- ar_new(~gender:answer, levels=universe, values=1:4)
t2
t3 <- ar_new(~gender:answer, c(2,2), values=1:4)
t3

## Extract arrays from dataframe (much like xtabs() but with more flexibility)
data(cad1) 
df2xtabs(cad1, ~Sex:AngPec:AMI)
df2xtabs(cad1, c("Sex","AngPec","AMI"))
df2xtabs(cad1, c(1,2,3))

universe <- list(gender=c('male','female'),
                 answer=c('yes','no'),
                 rain=c('yes','no'))
t1 <- ar_new(c("gender","answer"), levels=universe, values=1:4)

t1
t2 <- ar_new(~gender:answer, levels=universe, values=1:4)
t2
t3 <- ar_new(~gender:answer, c(2,2), values=1:4)
t3
}
\seealso{
\code{\link{ar_perm}}, \code{\link{ar_add}},
    \code{\link{ar_prod}} etc.
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
