% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{criterionPoints}
\alias{criterionPoints}
\title{Calculate the criterion points of a set of points and find the set of non-dominated points
(pareto points) and classify them into extreme supported, non-extreme supported, non-supported.}
\usage{
criterionPoints(points, c1, c2, crit)
}
\arguments{
\item{points}{A data frame with columns x1 and x2.}

\item{c1}{2D vector for first criterion.}

\item{c2}{2D vector for second criterion.}

\item{crit}{Either max or min.}
}
\value{
A data frame with columns x1, x2, z1 = c1*x, z2 = c2*x, z = z1 + z2, lbl = label, nD =
  non-dominated, ext = extreme, nonExt = non-extreme supported.
}
\description{
Calculate the criterion points of a set of points and find the set of non-dominated points
(pareto points) and classify them into extreme supported, non-extreme supported, non-supported.
}
\examples{
# Create the LP using lpSolveAPI package
LP <- make.lp(0, 2)
set.objfn(LP, c(7.75, 10))
add.constraint(LP, c(9, 10), "<=", 90)
add.constraint(LP, c(2, 4), "<=", 27)
add.constraint(LP, c(-3, 2), "<=", 3)
colNames <- c("x1", "x2")
colnames(LP) <- colNames
set.type(LP, c(1,2), type = "integer")
control <- lp.control(LP, sense='max')

# Corner points of the polytope
cPoints<-cornerPoints(getA(LP), get.rhs(LP))
# Integer points in the polytope
iPoints<-integerPoints(LP)

# Plot of the polytope
plotPolytope(cPoints)
plotPolytope(points = cPoints)
plotPolytope(points = iPoints)
plotPolytope(cPoints, cPoints, iso = getC(LP), crit = substr(lp.control(LP)$sense,1,3))
plotPolytope(cPoints, iPoints, iso = getC(LP), crit = substr(lp.control(LP)$sense,1,3))
plotPolytope(cPoints, iPoints, showLbl = TRUE)
plotPolytope(cPoints, iPoints, iso = c(3,-3), crit = "min")
plotPolytope(cPoints, iPoints) + xlab("x") + ylab("y")

# Plot of criterion points given a bi-objective vector
zPoints<-criterionPoints(iPoints, c1 = c(getC(LP)[1], 0), c2 = c(0, getC(LP)[2]),
                         crit = substr(lp.control(LP)$sense,1,3))
head(zPoints)
plotCriterion(zPoints)
plotCriterion(zPoints, addHull = FALSE, addTriangles = TRUE)
# mimimize
zPoints<-criterionPoints(zPoints, c1 = c(-1, 1), c2 = c(1, -1), crit = "min")
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min")
# identify solutions (x1,x2) corresponding to (z1,z2) (solution points is also given another shape)
plotPolytope(cPoints, zPoints, showLbl = TRUE, shape = zPoints$nD)
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min", showLbl = TRUE)
# max and min
zPoints<-criterionPoints(iPoints, c1 = c(-2, -1), c2 = c(1, 4), crit = "max")
plotPolytope(cPoints, zPoints, showLbl = TRUE)
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "max", showLbl = TRUE)
zPoints<-criterionPoints(iPoints, c1 = c(-2, -1), c2 = c(1, 4), crit = "min")
plotCriterion(zPoints, addHull = TRUE, addTriangles = TRUE, crit = "min", showLbl = TRUE)

\dontrun{
# Generate tikz file for LaTeX
library(tikzDevice)
tikz(file = "plot_polytope.tex", standAlone=F, width = 7, height = 6)
plotPolytope(cPoints, zPoints, showLbl = TRUE)
dev.off()
}

}
\author{
Lars Relund \email{lars@relund.dk}
}

