/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.af.gMCP.gui.graph.LaTeXTool;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.power.Group;
import org.af.gMCP.gui.power.SampleSizeDialog;

public class GroupPanel
extends JPanel
implements ActionListener {
    List<Group> gv = new Vector<Group>();
    JButton addScenario = new JButton("Add scenario");
    JButton rmScenario = new JButton("Remove last scenario");
    SampleSizeDialog sd;
    JPanel panel = new JPanel();

    public GroupPanel(SampleSizeDialog sd) {
        this.sd = sd;
        this.gv.add(new Group(sd, "Group " + (this.gv.size() + 1)));
        this.setUpLayout();
    }

    public void setUpLayout() {
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, fill:min:grow, pref, 5dlu, pref, 5dlu";
        String rows = "5dlu, fill:min:grow, 5dlu, pref, 5dlu";
        this.setLayout((LayoutManager)new FormLayout(cols, rows));
        this.add((Component)new JScrollPane(this.getMainPanel()), cc.xyw(2, row, 4));
        this.add((Component)this.addScenario, cc.xy(3, row += 2));
        this.add((Component)this.rmScenario, cc.xy(5, row));
        this.addScenario.addActionListener(this);
        this.rmScenario.addActionListener(this);
        this.rmScenario.setEnabled(false);
    }

    public JPanel getMainPanel() {
        this.panel.removeAll();
        CellConstraints cc = new CellConstraints();
        int row = 2;
        String cols = "5dlu, pref, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.sd.getNodes()) {
            cols = cols + ", pref, 5dlu";
        }
        for (Group g : this.gv) {
            rows = rows + ", pref, 5dlu";
        }
        this.panel.setLayout((LayoutManager)new FormLayout(cols, rows));
        int col = 2;
        this.panel.add((Component)new JLabel("Scenario name"), cc.xy(col, row));
        for (Node n : this.sd.getParent().getGraphView().getNL().getNodes()) {
            this.panel.add((Component)new JLabel("NCP " + LaTeXTool.LaTeX2UTF(n.getName()) + "    "), cc.xy(col += 2, row));
        }
        for (Group g : this.gv) {
            g.addComponents(this.panel, cc, row += 2);
        }
        return this.panel;
    }

    public String getNCPString() {
        String sList = ", list(";
        for (Group group : this.gv) {
        }
        return sList.substring(0, sList.length() - 2) + ")";
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addScenario) {
            this.gv.add(new Group(this.sd, "Group " + (this.gv.size() + 1)));
            this.getMainPanel();
            this.revalidate();
            this.repaint();
            this.rmScenario.setEnabled(true);
        } else if (e.getSource() == this.rmScenario) {
            if (this.gv.size() > 1) {
                this.gv.remove(this.gv.size() - 1);
                this.getMainPanel();
                this.revalidate();
                this.repaint();
            }
            if (this.gv.size() == 1) {
                this.rmScenario.setEnabled(false);
            }
        }
    }
}

