/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.af.commons.images.GraphDrawHelper;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.NetList;
import org.af.gMCP.gui.graph.NetListPopUpMenu;
import org.af.gMCP.gui.graph.NetListSelectionPopUpMenu;
import org.af.gMCP.gui.graph.Node;
import org.af.gMCP.gui.graph.UpdateEdge;
import org.af.gMCP.gui.graph.UpdateNode;
import org.af.gMCP.gui.graph.annotations.Annotation;
import org.af.gMCP.gui.graph.annotations.AnnotationPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetListPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
AnnotationPanel {
    int[] dragN = new int[0];
    int[] dragE = new int[0];
    int[] dragA = new int[0];
    static DecimalFormat format = new DecimalFormat("#.####");
    boolean unAnchor = false;
    Node firstVertex;
    boolean firstVertexSelected = false;
    boolean newEdge = false;
    boolean newVertex = false;
    public static Color[] layerColors = new Color[]{Color.BLACK, Color.RED, Color.BLUE, Color.GREEN, Color.YELLOW};
    NetList nl;
    Integer layer;
    Point arrowHeadPoint = null;
    protected int[][] offsetE;
    protected int[][] offsetN;
    protected int[][] offsetA;
    protected int[] startingPoint = null;
    protected int[] endPoint = null;

    public NetListPanel(NetList nl, Integer layer) {
        this.nl = nl;
        this.layer = layer;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public BufferedImage getImage(Double zoom) {
        if (zoom == null) {
            zoom = this.getZoom();
        }
        double oldZoom = this.getZoom();
        this.setZoom(zoom);
        this.nl.highlightEdge(-1, -1, -1);
        Point p = this.nl.getMaxPoint();
        BufferedImage img = new BufferedImage((int)((p.getX() + (double)(2 * Node.getRadius()) + 400.0) * this.getZoom()), (int)((p.getY() + (double)(2 * Node.getRadius()) + 400.0) * this.getZoom()), 2);
        Graphics2D g = img.createGraphics();
        if (!Configuration.getInstance().getGeneralConfig().exportTransparent()) {
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
        }
        g.setStroke(new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.getNodes()) {
            node.paintYou(g, this.layer);
        }
        for (Edge edge : this.getEdges()) {
            if (!this.shouldDraw(edge)) continue;
            edge.paintEdge(g);
        }
        for (Edge edge : this.getEdges()) {
            if (!this.shouldDraw(edge)) continue;
            edge.paintEdgeLabel(g);
        }
        img = this.cutImage(img, 5);
        this.setZoom(oldZoom);
        return img;
    }

    private List<Node> getNodes() {
        return this.nl.nodes;
    }

    private List<Edge> getEdges() {
        return this.nl.edges;
    }

    private List<Annotation> getAnnotations() {
        return this.nl.annotations;
    }

    private BufferedImage cutImage(BufferedImage img, int offset) {
        int minX = img.getWidth();
        int minY = img.getHeight();
        int maxX = 0;
        int maxY = 0;
        for (int x = 0; x < img.getWidth(); ++x) {
            for (int y = 0; y < img.getHeight(); ++y) {
                if (img.getRGB(x, y) == 0 || img.getRGB(x, y) == -1) continue;
                if (x < minX) {
                    minX = x;
                }
                if (y < minY) {
                    minY = y;
                }
                if (x > maxX) {
                    maxX = x;
                }
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return img.getSubimage(Math.max(0, minX - offset), Math.max(0, minY - offset), Math.min(maxX - minX + 2 * offset, img.getWidth()), Math.min(maxY - minY + 2 * offset, img.getHeight()));
    }

    public int[] calculateSize() {
        int i;
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.getNodes().size(); ++i) {
            if (this.getNodes().get(i).getX() > maxX) {
                maxX = this.getNodes().get(i).getX();
            }
            if (this.getNodes().get(i).getY() <= maxY) continue;
            maxY = this.getNodes().get(i).getY();
        }
        for (i = 0; i < this.getEdges().size(); ++i) {
            if (this.getEdges().get(i).getK1() > maxX) {
                maxX = this.getEdges().get(i).getK1();
            }
            if (this.getEdges().get(i).getK2() <= maxY) continue;
            maxY = this.getEdges().get(i).getK2();
        }
        this.setPreferredSize(new Dimension((int)((double)(maxX + 2 * Node.getRadius() + 30) * this.getZoom()), (int)((double)(maxY + 2 * Node.getRadius() + 30) * this.getZoom())));
        if (this.nl.updateGUI) {
            this.revalidate();
            this.repaint();
        }
        return new int[]{maxX, maxY};
    }

    public List<String> getHNames() {
        Vector<String> v = new Vector<String>();
        for (Node n : this.getNodes()) {
            v.add(n.getName());
        }
        return v;
    }

    @Override
    public double getZoom() {
        return this.nl.getZoom();
    }

    public void setZoom(double p) {
        this.nl.setZoom(p);
    }

    private void showPopUp(MouseEvent e, Node node, Edge edge) {
        NetListPopUpMenu menu = new NetListPopUpMenu(this.nl, node, edge);
        menu.show(e.getComponent(), e.getX(), e.getY());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.firstVertexSelected) {
            this.arrowHeadPoint = e.getPoint();
            this.repaint();
            return;
        }
        if (this.dragN.length == 0 && this.dragE.length == 0 && this.dragA.length == 0) {
            this.endPoint = new int[]{e.getX(), e.getY()};
            this.repaint();
            return;
        }
        for (int i : this.dragN) {
            if (!this.unAnchor && Configuration.getInstance().getGeneralConfig().getUnAnchor()) {
                for (Edge edge : this.getEdges()) {
                    if (edge.from != this.getNodes().get(i) && edge.to != this.getNodes().get(i)) continue;
                    edge.fixed = false;
                }
                this.unAnchor = true;
            }
            this.getNodes().get(i).setX((int)((double)(e.getX() + this.offsetN[i][0]) / this.getZoom()));
            this.getNodes().get(i).setY((int)((double)(e.getY() + this.offsetN[i][1]) / this.getZoom()));
            this.placeUnfixedNodes(this.getNodes().get(i));
        }
        for (int i : this.dragE) {
            this.getEdges().get(i).setK1((int)((double)(e.getX() + this.offsetE[i][0]) / this.getZoom()));
            this.getEdges().get(i).setK2((int)((double)(e.getY() + this.offsetE[i][1]) / this.getZoom()));
        }
        for (int i : this.dragA) {
            this.getAnnotations().get(i).setX((int)((double)(e.getX() + this.offsetA[i][0]) / this.getZoom()));
            this.getAnnotations().get(i).setY((int)((double)(e.getY() + this.offsetA[i][1]) / this.getZoom()));
        }
        this.calculateSize();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.firstVertexSelected) {
            this.arrowHeadPoint = e.getPoint();
            this.repaint();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popUp(e);
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.newVertex = false;
            this.firstVertexSelected = false;
            this.firstVertex = null;
            this.arrowHeadPoint = null;
            this.nl.control.buttonNewNode.setSelected(false);
            this.repaint();
            return;
        }
        if (this.newVertex && this.vertexSelected(e.getX(), e.getY()) == null) {
            this.nl.addDefaultNode((int)((double)e.getX() / this.getZoom()) - Node.r, (int)((double)e.getY() / this.getZoom()) - Node.r);
            this.nl.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
        if (this.newEdge) {
            if (!this.firstVertexSelected) {
                this.firstVertex = this.vertexSelected(e.getX(), e.getY());
                if (this.firstVertex == null) {
                    return;
                }
                this.firstVertexSelected = true;
                this.nl.statusBar.setText("Select a second node to which the edge should lead.");
            } else {
                Node secondVertex = this.vertexSelected(e.getX(), e.getY());
                if (secondVertex == null || secondVertex == this.firstVertex) {
                    if (secondVertex == this.firstVertex) {
                        this.firstVertexSelected = false;
                        this.firstVertex = null;
                        this.arrowHeadPoint = null;
                    }
                    return;
                }
                this.nl.setEdge(this.firstVertex, secondVertex, this);
                this.nl.edgeWasSet();
                this.nl.statusBar.setText("Place new nodes and edges or start the test procedure");
            }
            this.repaint();
            return;
        }
        if (this.dragN.length != 0 || this.dragE.length != 0) {
            this.offsetN = new int[this.getNodes().size()][2];
            this.offsetE = new int[this.getEdges().size()][2];
            for (int i : this.dragN) {
                this.offsetN[i] = this.getNodes().get(i).offset(e.getX(), e.getY());
            }
            for (int i : this.dragE) {
                this.offsetE[i] = this.getEdges().get(i).offset(e.getX(), e.getY());
            }
        } else {
            int i;
            for (i = 0; i < this.getNodes().size(); ++i) {
                if (!this.getNodes().get(i).inYou(e.getX(), e.getY())) continue;
                this.dragN = new int[]{i};
                this.offsetN = new int[this.getNodes().size()][2];
                this.offsetN[i] = this.getNodes().get(i).offset(e.getX(), e.getY());
            }
            for (i = this.getEdges().size() - 1; i >= 0; --i) {
                if (!this.getEdges().get(i).inYou(e.getX(), e.getY())) continue;
                this.dragN = new int[0];
                this.dragE = new int[]{i};
                this.offsetE = new int[this.getEdges().size()][2];
                this.offsetE[i] = this.getEdges().get(i).offset(e.getX(), e.getY());
            }
            for (i = this.getAnnotations().size() - 1; i >= 0; --i) {
                if (!this.getAnnotations().get(i).inYou(e.getX(), e.getY())) continue;
                this.dragN = new int[0];
                this.dragE = new int[0];
                this.dragA = new int[]{i};
                this.offsetA = new int[this.getAnnotations().size()][2];
                this.offsetA[i] = this.getAnnotations().get(i).offset(e.getX(), e.getY());
            }
        }
        if (e.getClickCount() == 2 && !this.nl.testingStarted) {
            int i;
            for (i = this.getEdges().size() - 1; i >= 0; --i) {
                if (!this.getEdges().get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateEdge(this.getEdges().get(i), this.nl, this.nl.control);
                this.mouseReleased(null);
                this.repaint();
                return;
            }
            for (i = this.getNodes().size() - 1; i >= 0; --i) {
                if (!this.getNodes().get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateNode(this.getNodes().get(i), this.nl.control);
                this.mouseReleased(null);
                this.repaint();
                return;
            }
        }
        this.startingPoint = new int[]{e.getX(), e.getY()};
        this.repaint();
    }

    public Node vertexSelected(int x, int y) {
        for (Node n : this.getNodes()) {
            if (!n.inYou(x, y)) continue;
            return n;
        }
        return null;
    }

    private void placeUnfixedNodes(Node node) {
        for (Edge e : this.getEdges()) {
            if (e.from != node && e.to != node || e.isFixed()) continue;
            e.move();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        for (int i : this.dragE) {
            this.getEdges().get(i).setFixed(true);
        }
        this.dragN = new int[0];
        this.dragE = new int[0];
        this.dragA = new int[0];
        if (e != null) {
            if (this.endPoint != null && this.startingPoint != null && Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
                Vector<Node> nodes = new Vector<Node>();
                Vector<Edge> edges = new Vector<Edge>();
                for (Edge edge : this.getEdges()) {
                    if (!edge.containsYou(this.startingPoint, this.endPoint)) continue;
                    edges.add(edge);
                }
                for (Node node : this.getNodes()) {
                    if (!node.containsYou(this.startingPoint, this.endPoint)) continue;
                    nodes.add(node);
                }
                NetListSelectionPopUpMenu menu = new NetListSelectionPopUpMenu(this.nl, nodes, edges);
                this.repaint();
                menu.show(e.getComponent(), e.getX() - 20, e.getY() - 20);
            } else if (e.isPopupTrigger()) {
                this.popUp(e);
            }
        }
        this.unAnchor = false;
        this.endPoint = null;
        if (e != null && this.newEdge && this.firstVertexSelected) {
            Node secondVertex = this.vertexSelected(e.getX(), e.getY());
            if (secondVertex == null || secondVertex == this.firstVertex) {
                return;
            }
            this.nl.setEdge(this.firstVertex, secondVertex, this);
            this.nl.edgeWasSet();
            this.nl.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
    }

    public void popUp(MouseEvent e) {
        int i;
        for (i = 0; i < this.getNodes().size(); ++i) {
            if (!this.getNodes().get(i).inYou(e.getX(), e.getY())) continue;
            this.showPopUp(e, this.getNodes().get(i), null);
        }
        for (i = this.getEdges().size() - 1; i >= 0; --i) {
            if (!this.getEdges().get(i).inYou(e.getX(), e.getY())) continue;
            this.showPopUp(e, null, this.getEdges().get(i));
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (!this.nl.updateGUI) {
            return;
        }
        super.paintComponent(g);
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        g.setColor(Color.LIGHT_GRAY);
        if (grid > 1) {
            int x = (int)((double)Node.r * this.getZoom());
            while (x < this.getWidth()) {
                g.drawLine(x, 0, x, this.getHeight());
                x = (int)((double)x + (double)grid * this.getZoom());
            }
            x = (int)((double)Node.r * this.getZoom());
            while (x > 0) {
                g.drawLine(x, 0, x, this.getHeight());
                x = (int)((double)x - (double)grid * this.getZoom());
            }
            int y = (int)((double)Node.r * this.getZoom());
            while (y < this.getHeight()) {
                g.drawLine(0, y, this.getWidth(), y);
                y = (int)((double)y + (double)grid * this.getZoom());
            }
            y = (int)((double)Node.r * this.getZoom());
            while (y > 0) {
                g.drawLine(0, y, this.getWidth(), y);
                y = (int)((double)y - (double)grid * this.getZoom());
            }
        }
        BasicStroke stroke = new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth());
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.getNodes()) {
            node.paintYou(g, this.layer);
        }
        for (Edge edge : this.getEdges()) {
            if (!this.shouldDraw(edge)) continue;
            edge.paintEdge(g);
        }
        for (Edge edge : this.getEdges()) {
            if (!this.shouldDraw(edge)) continue;
            edge.paintEdgeLabel(g);
        }
        if (this.endPoint != null && this.startingPoint != null && Configuration.getInstance().getGeneralConfig().experimentalFeatures()) {
            int x = Math.min(this.startingPoint[0], this.endPoint[0]);
            int y = Math.min(this.startingPoint[1], this.endPoint[1]);
            int width = Math.abs(this.startingPoint[0] - this.endPoint[0]);
            int height = Math.abs(this.startingPoint[1] - this.endPoint[1]);
            ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
            ((Graphics2D)g).setPaint(new Color(0, 0, 255, 30));
            ((Graphics2D)g).fillRect(x, y, width, height);
            ((Graphics2D)g).setPaint(new Color(0, 0, 255));
            ((Graphics2D)g).drawRect(x, y, width, height);
        }
        if (this.firstVertexSelected && this.firstVertex != null && this.arrowHeadPoint != null) {
            double c2;
            double a1 = this.firstVertex.getX() + Node.getRadius();
            double a2 = this.firstVertex.getY() + Node.getRadius();
            double c1 = this.arrowHeadPoint.getX() / this.getZoom();
            if (!this.firstVertex.inYou((int)c1, (int)(c2 = this.arrowHeadPoint.getY() / this.getZoom()))) {
                double dx = a1 - c1;
                double dy = a2 - c2;
                double d = Math.sqrt(dx * dx + dy * dy);
                g.setColor(Color.DARK_GRAY);
                GraphDrawHelper.malVollenPfeil((Graphics)g, (int)((int)((a1 -= (double)Node.getRadius() * dx / d) * this.getZoom())), (int)((int)((a2 -= (double)Node.getRadius() * dy / d) * this.getZoom())), (int)((int)(c1 * this.getZoom())), (int)((int)(c2 * this.getZoom())), (int)((int)(8.0 * this.getZoom())), (int)35);
                g.setColor(Color.BLACK);
            }
        }
        for (Annotation a : this.nl.annotations) {
            a.paintObject(g);
        }
    }

    private boolean shouldDraw(Edge edge) {
        if (this.layer == null) {
            return true;
        }
        return this.layer == edge.layer;
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void reset() {
        this.firstVertexSelected = false;
        this.newVertex = false;
        this.newEdge = false;
    }
}

