/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.af.gMCP.config.Configuration;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXIcon;

public class LaTeXTool {
    public static Component panel = new JPanel();
    public static final String[] greekLaTeX = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omega"};
    public static final char[] greek = new char[]{'\u03b1', '\u03b2', '\u03b3', '\u03b4', '\u03b5', '\u03b6', '\u03b7', '\u03b8', '\u03b9', '\u03ba', '\u03bb', '\u03bc', '\u03bd', '\u03be', '\u03c0', '\u03c1', '\u03c3', '\u03c4', '\u03c5', '\u03c6', '\u03c7', '\u03c8', '\u03c9'};
    public static final String NO_GREEK_CHARACTER = "No greek character";

    public static String StringToLaTeX(String s) {
        String latex = "";
        if (s.indexOf("E-") != -1) {
            latex = s.replaceAll("E-", "}{10^{");
            latex = "\\frac{" + latex + "}}";
        } else {
            int openBracket = 0;
            boolean waitingForDenominator = false;
            String nominator = "";
            s.replaceAll("\u03b5", "\\varepsilon");
            s.replaceAll(" ", "");
            for (int i = 0; i < s.length(); ++i) {
                String c = "" + s.charAt(i);
                if (c.equals("(")) {
                    ++openBracket;
                }
                if (c.equals(")")) {
                    --openBracket;
                }
                if ((c.equals("+") || c.equals("-") || c.equals("*") || c.equals(")") && i + 1 < s.length() && !(s.charAt(i + 1) + "").equals("/")) && openBracket == 0) {
                    String start = s.substring(0, i + 1);
                    if (waitingForDenominator) {
                        latex = c.equals(")") ? latex + "\\frac{" + nominator + "}{" + start + "}" : latex + "\\frac{" + nominator + "}{" + start.substring(0, i) + "}" + c;
                        waitingForDenominator = false;
                    } else {
                        latex = latex + start;
                    }
                    s = s.substring(i + 1, s.length());
                    i = -1;
                }
                if (!c.equals("/")) continue;
                nominator = s.substring(0, i);
                s = s.substring(i + 1, s.length());
                i = -1;
                waitingForDenominator = true;
            }
            latex = waitingForDenominator ? latex + "\\frac{" + nominator + "}{" + s + "}" : latex + s;
            latex = latex.replaceAll("\\*", Configuration.getInstance().getGeneralConfig().getTimesSymbol());
            latex = latex.replaceAll("\\(", "{(");
            latex = latex.replaceAll("\\)", ")}");
        }
        return latex;
    }

    public static TeXIcon getTeXIcon(JFrame parent, String s, int points) {
        try {
            String latex = LaTeXTool.StringToLaTeX(s);
            TeXFormula formula = new TeXFormula(latex);
            formula = new TeXFormula("\\mathbf{" + latex + "}");
            TeXIcon result = formula.createTeXIcon(2, (float)points);
            if (result.getIconWidth() > 60) {
                result = formula.createTeXIcon(2, (float)((int)((double)points * 0.7)));
            }
            return result;
        }
        catch (Exception e) {
            TeXFormula formula = new TeXFormula("Syntax Error");
            return formula.createTeXIcon(2, (float)((int)((double)points * 0.7)));
        }
    }

    public static void main(String[] args) {
        System.out.println(LaTeXTool.StringToLaTeX("3E-6"));
        System.out.println(LaTeXTool.StringToLaTeX("(1+2\u03b5)/3"));
        System.out.println(LaTeXTool.LaTeX2UTF("2*\\nu=\\epsilon"));
    }

    public static String LaTeX2UTF(String s) {
        for (int i = 0; i < greek.length; ++i) {
            s = s.replaceAll("\\\\" + greekLaTeX[i], "" + greek[i]);
        }
        return s;
    }

    public static String UTF2LaTeX(char greekC) {
        for (int i = 0; i < greek.length; ++i) {
            if (greekC != greek[i]) continue;
            return greekLaTeX[i];
        }
        return "" + greekC;
    }

    public static String UTF2LaTeX(String s) {
        for (int i = 0; i < greek.length; ++i) {
            s = s.replaceAll("" + greek[i], greekLaTeX[i]);
        }
        return s;
    }
}

