/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.graph;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.dialogs.ColorChooseDialog;
import org.af.gMCP.gui.graph.Edge;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.GraphView;
import org.af.gMCP.gui.graph.NetList;

public class UpdateEdge
extends JDialog
implements ActionListener {
    JTextField tf;
    JButton jb = new JButton("Update Edge");
    JButton jbDelete = new JButton("Remove Edge");
    JButton jbColor = new JButton("Choose Color");
    Edge edge;
    NetList netzListe;
    GraphView control;
    JTabbedPane tabbedPane = new JTabbedPane();
    JCheckBox jcbAnchored = new JCheckBox("Weight is anchored and does not follows nodes when moved.");
    JSpinner spinner = new JSpinner(new SpinnerNumberModel(2, 1, 10, 1));
    JLabel colorLabel = new JLabel("     ");

    public UpdateEdge(Edge edge, NetList netzListe, GraphView control) {
        super(netzListe.control.parent, "Updating Edge from node " + edge.from.getName() + " to " + edge.to.getName(), true);
        this.control = control;
        this.edge = edge;
        this.netzListe = netzListe;
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, fill:pref:grow, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        this.getContentPane().setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.tabbedPane.addTab("Weight & Anchor", this.getMainPanel());
        this.tabbedPane.addTab("Further Attributes", this.getSubPanel());
        this.getContentPane().add((Component)this.tabbedPane, cc.xyw(1, 2, 5));
        this.jbDelete.addActionListener(this);
        this.getContentPane().add((Component)this.jbDelete, cc.xy(2, 4));
        this.jb.addActionListener(this);
        this.getContentPane().add((Component)this.jb, cc.xy(4, 4));
        this.pack();
        this.setSize(Math.max(this.getSize().width, 450), this.getSize().height);
        this.setLocation(300, 300);
        this.setVisible(true);
    }

    protected JPanel getMainPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)new JLabel("Weight for edge:"), cc.xy(2, 2));
        String text = this.edge.getWS();
        this.tf = new JTextField(text);
        this.tf.addActionListener(this);
        panel.add((Component)this.tf, cc.xy(4, 2));
        this.jcbAnchored.addActionListener(this);
        this.jcbAnchored.setSelected(this.edge.isFixed());
        if (!Configuration.getInstance().getGeneralConfig().getUnAnchor()) {
            panel.add((Component)this.jcbAnchored, cc.xyw(2, 4, 3));
        }
        return panel;
    }

    protected JPanel getSubPanel() {
        JPanel panel = new JPanel();
        String cols = "5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        panel.add((Component)new JLabel("Color:"), cc.xy(2, row));
        this.colorLabel.setOpaque(true);
        this.colorLabel.setBackground(this.edge.color);
        panel.add((Component)this.colorLabel, cc.xy(4, row));
        this.jbColor.addActionListener(this);
        panel.add((Component)this.jbColor, cc.xy(6, row));
        panel.add((Component)new JLabel("Line width:"), cc.xy(2, row += 2));
        panel.add((Component)this.spinner, cc.xy(4, row));
        return panel;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.jbColor) {
            ColorChooseDialog ccd = new ColorChooseDialog(this);
            this.edge.color = ccd.getColor();
            this.colorLabel.setBackground(this.edge.color);
            return;
        }
        if (e.getSource() == this.jcbAnchored) {
            this.edge.setFixed(this.jcbAnchored.isSelected());
            return;
        }
        Double w = 0.0;
        if (e.getSource() != this.jbDelete) {
            try {
                w = Double.parseDouble(this.tf.getText());
            }
            catch (NumberFormatException ve) {
                w = Double.NaN;
            }
            if (this.tf.getText().length() == 0) {
                w = 0.0;
            }
        }
        if (w == 0.0) {
            this.control.getDataFramePanel().setValueAt(new EdgeWeight(0.0), this.netzListe.getNodes().indexOf(this.edge.from), this.netzListe.getNodes().indexOf(this.edge.to), this.edge.layer);
            this.netzListe.removeEdge(this.edge);
        } else {
            this.edge.setW(this.tf.getText());
            int n = Integer.parseInt(this.spinner.getModel().getValue().toString());
            this.edge.linewidth = n;
            this.control.getDataFramePanel().setValueAt(new EdgeWeight(this.tf.getText()), this.netzListe.getNodes().indexOf(this.edge.from), this.netzListe.getNodes().indexOf(this.edge.to), this.edge.layer);
        }
        this.netzListe.repaint();
        this.dispose();
    }
}

