/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.errorhandling.HTTPPoster;
import org.af.commons.io.FileTools;
import org.af.commons.io.Zipper;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.threading.SafeSwingWorker;
import org.af.commons.tools.OSTools;
import org.af.commons.tools.StringTools;
import org.af.commons.widgets.GUIToolKit;
import org.af.commons.widgets.MultiLineLabel;
import org.af.commons.widgets.WidgetFactory;
import org.af.commons.widgets.buttons.HorizontalButtonPane;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.ReproducableLog;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.jdesktop.jxlayer.plaf.ext.LockableUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorDialogGMCP
extends JDialog
implements ActionListener {
    static int count = 0;
    static File tempDir = new File(System.getProperty("java.io.tmpdir"), "gMCP" + Calendar.getInstance().getTime());
    protected static Log logger = LogFactory.getLog(ErrorDialogGMCP.class);
    protected ApplicationLog al;
    protected final Object e;
    protected final boolean fatal;
    protected String informMsg = "";
    protected LockableUI lockableUI;
    protected final String msg;
    protected String message = "";
    protected String stacktrace = "";
    protected JTextArea taDesc;
    protected MultiLineLabel taHeader;
    protected JTextField tfContact;

    public static File makeLogFile(String fileName, String content) throws IOException {
        tempDir.mkdirs();
        File output = new File(tempDir, fileName);
        FileWriter fw = new FileWriter(output);
        fw.write(content);
        fw.close();
        return output;
    }

    public ErrorDialogGMCP(String msg, Object e, boolean fatal) {
        super(GUIToolKit.findActiveFrame(), true);
        this.fatal = fatal;
        this.e = e;
        if (e != null && e instanceof Throwable) {
            ((Throwable)e).printStackTrace();
        }
        this.msg = msg;
        if (e != null) {
            if (e instanceof Throwable) {
                this.message = ((Throwable)e).getMessage();
                this.stacktrace = ExceptionUtils.getStackTrace((Throwable)((Throwable)e));
            } else {
                this.message = e.toString();
            }
        }
        if (this.message == null) {
            this.message = "";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("CANCEL")) {
            this.onExit();
        }
        if (e.getActionCommand().equals("OK")) {
            this.onInform();
        }
    }

    private void doTheLayout() {
        this.lockableUI = GUIToolKit.setContentPaneAsLockableJXLayer((JRootPane)this.getRootPane(), (JPanel)this.getPanel());
        JTabbedPane dd = new JTabbedPane();
        dd.setTabLayoutPolicy(1);
        dd.add("Report", this.getPanel());
        Hashtable<Object, Object> files = new Hashtable();
        try {
            files = this.getAttachedFiles();
            for (File file : files.values()) {
                if (file.getName().toLowerCase().endsWith(".jpg")) continue;
                JTextArea textArea = new JTextArea(5, 10);
                textArea.setText(FileTools.readFileAsString((File)file));
                textArea.setEditable(false);
                dd.add(file.getName(), new JScrollPane(textArea));
            }
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "IO-Error while accessing log file!");
        }
        OkCancelButtonPane bp = new OkCancelButtonPane("Ok", "Cancel");
        this.setContentPane(WidgetFactory.makeDialogPanelWithButtons((Container)dd, (HorizontalButtonPane)bp, (ActionListener)this));
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    protected Hashtable<String, File> getAttachedFiles() throws IOException {
        Hashtable<String, File> files = new Hashtable<String, File>();
        try {
            files.put("log", this.getReadableLogFile());
            files.put("systeminfo", ErrorDialogGMCP.makeLogFile("system_info.txt", this.getSystemInfo()));
            Vector rhistory = new Vector();
            for (int i = 0; i < RControl.getR().getHistory().size(); ++i) {
                rhistory.add(RControl.getR().getHistory().get(i));
            }
            files.put("rcommands", ErrorDialogGMCP.makeLogFile("r_commands.txt", StringTools.collapseStringList(rhistory, (String)"\n")));
            files.put("sessioninfo", ErrorDialogGMCP.makeLogFile("session_info.txt", this.getRSessionInfo()));
            files.put("roptions", ErrorDialogGMCP.makeLogFile("r_options.txt", this.getROptions()));
            files.put("traceback", ErrorDialogGMCP.makeLogFile("taceback.txt", this.getTraceBack()));
            files.put("graph", ErrorDialogGMCP.makeLogFile("graph.txt", this.getGraph()));
            files.put("config", ErrorDialogGMCP.makeLogFile("config.txt", Configuration.getInstance().getConfigurationForDebugPurposes()));
            files.put("abstractR", ErrorDialogGMCP.makeLogFile("abstractR.txt", ReproducableLog.getRLog()));
            files.put("userInteraction", ErrorDialogGMCP.makeLogFile("userInteraction.txt", ReproducableLog.getGUILog()));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Not all information could be collected for error reporting:\n" + e.getMessage(), "Error while reporting error", 0);
            e.printStackTrace();
        }
        return files;
    }

    private String getGraph() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("gMCP:::getDebugInfo()").asRChar().getData());
    }

    protected Hashtable<String, String> getInfoTable() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("Contact", this.tfContact.getText());
        try {
            table.put("Shortinfo", OSTools.getShortInfo());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        table.put("Description", this.taDesc.getText());
        if (this.e != null) {
            if (this.e instanceof Throwable) {
                table.put("A StackTrace", StringTools.stackTraceToString((Throwable)((Throwable)this.e)));
                if (((Throwable)this.e).getMessage() != null) {
                    table.put("Error message", ((Throwable)this.e).getMessage());
                }
            } else {
                table.put("Error", this.e.toString());
            }
        }
        String prefix = "";
        if (this.tfContact.getText().length() > 2 || this.taDesc.getText().length() > 2) {
            prefix = "A FILLED OUT ";
        }
        String subject = prefix + "gMCP " + Configuration.getInstance().getGeneralConfig().getVersionNumber() + " (R " + Configuration.getInstance().getGeneralConfig().getRVersionNumber() + ") " + "bug report from " + System.getProperty("user.name", "<unknown user name>") + " on " + System.getProperty("os.name", "<unknown OS>") + " : " + (this.message.length() < 40 ? this.message : this.message.substring(0, 37) + "...");
        table.put("Subject", subject);
        return table;
    }

    protected JPanel getOptionalPanel() {
        this.al = LoggingSystem.getInstance().getApplicationLog();
        JPanel p = new JPanel();
        String cols = "left:pref, 5dlu, pref:grow";
        String rows = "pref";
        FormLayout layout = new FormLayout(cols, rows);
        p.setLayout((LayoutManager)layout);
        return p;
    }

    protected JPanel getPanel() {
        JPanel p = new JPanel();
        String cols = "5dlu, left:pref, 5dlu, f:d:g, 5dlu";
        String rows = "5dlu, pref, 5dlu, f:p:g, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu";
        FormLayout layout = new FormLayout(cols, rows);
        p.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        p.add((Component)new JLabel("<html>" + this.msg.replaceAll("\n", "<br>") + "</html>"), cc.xyw(2, row, 3));
        p.add((Component)this.taHeader, cc.xyw(2, row, 3));
        p.add((Component)new JLabel("Description:"), cc.xy(1, row += 2));
        JScrollPane sp1 = new JScrollPane(this.taDesc);
        p.add((Component)sp1, cc.xy(4, row));
        p.add((Component)new JLabel("OPTIONAL: If you want to help or get feedback, give us some way to contact you:"), cc.xyw(2, row += 2, 3));
        p.add((Component)new JLabel("Optional contact (email, phone)"), cc.xy(2, row += 2));
        p.add((Component)this.tfContact, cc.xy(4, row));
        p.add((Component)this.getOptionalPanel(), cc.xyw(2, row += 2, 3));
        return p;
    }

    public File getReadableLogFile() {
        return new File(this.getReadableLogFileAppender().getFile());
    }

    public FileAppender getReadableLogFileAppender() {
        return (FileAppender)Logger.getRootLogger().getAppender("READABLE_FILE");
    }

    private String getROptions() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(options()), collapse=\"\\n\")").asRChar().getData());
    }

    private String getRSessionInfo() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(sessionInfo()), collapse=\"\\n\")").asRChar().getData());
    }

    private String getSystemInfo() {
        return this.al.getSystemInfo();
    }

    private String getTraceBack() {
        return StringTools.collapseStringArray((String[])RControl.getR().eval("paste(capture.output(traceback()), collapse=\"\\n\")").asRChar().getData());
    }

    private void makeComponents() {
        this.taHeader = new MultiLineLabel(this.informMsg);
        this.tfContact = new JTextField();
        this.taDesc = new JTextArea(4, 30);
    }

    protected void onExit() {
        this.dispose();
    }

    protected void onInform() {
        this.lockableUI.setLocked(true);
        SafeSwingWorker<Void, Void> worker = new SafeSwingWorker<Void, Void>(){

            protected Void doInBackground() throws Exception {
                new HTTPPoster().post(ErrorHandler.getInstance().getReportURL(), ErrorDialogGMCP.this.getInfoTable(), ErrorDialogGMCP.this.getAttachedFiles());
                return null;
            }

            protected void onFailure(Throwable t) {
                String msg = "Could not connect to server and send report.\n(" + t.getMessage() + ")\nPlease send mail manually!";
                logger.error((Object)msg, t);
                JOptionPane.showMessageDialog(ErrorDialogGMCP.this, msg);
                ErrorDialogGMCP.this.lockableUI.setLocked(false);
                String subject = "Error%20report";
                String body = "Description%20and%20contact%20information:";
                String mailtoURI = "mailto:" + ErrorHandler.getInstance().getDeveloperAddress() + "?SUBJECT=" + subject + "&BODY=" + body;
                try {
                    URI uriMailTo = new URI(mailtoURI);
                    Method main = Class.forName("java.awt.Desktop").getDeclaredMethod("getDesktop", new Class[0]);
                    Object obj = main.invoke((Object)new Object[0], new Object[0]);
                    Method second = obj.getClass().getDeclaredMethod("mail", URI.class);
                    second.invoke(obj, uriMailTo);
                }
                catch (Exception e) {
                    logger.warn((Object)"No Desktop class in Java 5 or URI error.", (Throwable)e);
                }
            }

            protected void onSuccess(Void result) {
                ErrorDialogGMCP.this.dispose();
                JOptionPane.showMessageDialog(ErrorDialogGMCP.this, "Report was sent.");
            }
        };
        worker.execute();
    }

    protected void onZip() {
        String info = "gMCP " + Configuration.getInstance().getGeneralConfig().getVersionNumber() + " (R " + Configuration.getInstance().getGeneralConfig().getRVersionNumber() + ") " + "bug report from " + System.getProperty("os.name", "<unknown OS>") + ": ";
        String completeInfo = "Something went wrong.\nWe would be glad, if you could send us a mail to " + ErrorHandler.getInstance().getDeveloperAddress() + " with the following information:\n\n" + info + (this.stacktrace.isEmpty() ? "" : "\n\n") + this.stacktrace + "\n\n" + this.getTraceBack() + "\n\n" + this.getRSessionInfo();
        new TextFileViewer(null, "Error", completeInfo);
        this.dispose();
        try {
            this.getAttachedFiles();
            Zipper.writeIntoZip((File)tempDir, (File)new File(System.getProperty("java.io.tmpdir"), "gMCP" + Calendar.getInstance().getTime() + ".zip"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public File screen() throws IOException {
        CreateGraphGUI f = CreateGraphGUI.lastCreatedGUI;
        BufferedImage image = new BufferedImage(f.getWidth(), f.getHeight(), 1);
        Graphics2D graphics2D = image.createGraphics();
        f.paint(graphics2D);
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File file = new File(tempDir, "screen.jpg");
        ImageIO.write((RenderedImage)image, "jpeg", file);
        return file;
    }

    public void showDialog() {
        try {
            this.setTitle("Sorry, an error occured - please tell us about it.");
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    ErrorDialogGMCP.this.onExit();
                }
            });
            this.makeComponents();
            this.doTheLayout();
            this.setResizable(true);
            this.setAlwaysOnTop(true);
            this.setVisible(true);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Error during creating error dialog:\n" + e.getMessage(), "Error creating error dialog", 0);
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        RControl.getRControl(true);
        ErrorHandler.getInstance().makeErrDialog("Report Error");
    }
}

