% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPower.R
\name{extractPower}
\alias{extractPower}
\title{Calculate power values}
\usage{
extractPower(x, f = list())
}
\arguments{
\item{x}{A matrix containing the rejected hypothesis, as produces by the
graphTest function.}

\item{f}{List of user defined power functions. If one is interested in the
power to reject hypotheses 1 and 3 one could specify \code{function(x) {x[1]
&& x[3]}}. If f is a named list, the result will contain corresponding items 
with the same names (among the default elements described in the following).}
}
\value{
A list containg at least the following four elements and
an element for each element in the parameter \code{f}.
\describe{
\item{\code{LocPower}}{A numeric giving the local powers for the hypotheses}
\item{\code{ExpNrRej}}{The expected number of rejections}
\item{\code{PowAtlst1}}{The power to reject at least one hypothesis}
\item{\code{RejectAll}}{The power to reject all hypotheses}
}
}
\description{
Calculates local power values, expected number of rejections, the power to
reject at least one hypothesis and the power to reject all hypotheses.
}
\keyword{htest}

