/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.dialogs;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.datatable.CellEditorE;
import org.af.gMCP.gui.datatable.DataFramePanel;
import org.af.gMCP.gui.datatable.RDataFrameRef;
import org.af.gMCP.gui.graph.EdgeWeight;
import org.af.gMCP.gui.graph.Node;

public class PowerDialogParameterUncertainty
extends JDialog
implements ActionListener {
    JButton ok = new JButton("Ok");
    CreateGraphGUI parent;
    Vector<Node> nodes;
    List<JTextField> jtl;
    JTextArea jta = new JTextArea();
    JPanel panel = new JPanel();
    DataFramePanel dfp;
    JTextField jtUserDefined = new JTextField();

    public PowerDialogParameterUncertainty(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        RDataFrameRef df = new RDataFrameRef();
        for (Node n : parent.getGraphView().getNL().getNodes()) {
            df.addRowCol(n.getName());
            df.setValue(df.getColumnCount() - 1, df.getColumnCount() - 1, new EdgeWeight(1.0));
        }
        this.dfp = new DataFramePanel(df);
        this.dfp.getTable().getModel().diagEditable = true;
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(null, this.dfp.getTable()));
        this.jta.setText("Above you can specify the mean and covariance matrix of a multivariate\nnormal distribution that is used for power calculations.\n\nIn the text field on the right you can enter an user defined power function.\nExample:  (x[1] && x[2]) || x[4]\nThis calculates the probability that the first and second\nor (not exclusive) the fourth null hypothesis can be rejected.");
        String cols = "5dlu, pref, 5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref, 5dlu";
        for (Node n : this.nodes) {
            rows = rows + ", pref, 5dlu";
        }
        FormLayout layout = new FormLayout(cols, rows);
        this.panel.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 2;
        this.jtl = new Vector<JTextField>();
        for (Node n : this.nodes) {
            JTextField jt = new JTextField("0");
            this.panel.add((Component)new JLabel("Mean for '" + n.getName() + "':"), cc.xy(2, row));
            this.panel.add((Component)jt, cc.xy(4, row));
            this.jtl.add(jt);
            row += 2;
        }
        this.panel.add((Component)this.ok, cc.xy(4, row));
        this.ok.addActionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)new JScrollPane(this.panel), c);
        ++c.gridx;
        this.getContentPane().add((Component)new JScrollPane(this.dfp), c);
        c.gridx = 0;
        ++c.gridy;
        this.getContentPane().add((Component)new JScrollPane(this.jta), c);
        ++c.gridx;
        this.getContentPane().add((Component)new JScrollPane(this.jtUserDefined), c);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        double alpha = this.parent.getPView().getTotalAlpha();
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        double[] means = new double[this.nodes.size()];
        for (int i = 0; i < means.length; ++i) {
            means[i] = Double.parseDouble(this.jtl.get(i).getText());
        }
        String userDefinedF = this.jtUserDefined.getText().length() > 1 ? ", f=list(userDefined=function(x) {" + this.jtUserDefined.getText() + "})" : "";
        String mean = RControl.getRString(means);
        RControl.getR().eval(this.parent.getGraphView().getNL().getGraphName() + "<-gMCP:::parse2numeric(" + this.parent.getGraphView().getNL().getGraphName() + ")");
        RControl.getR().eval(".powerResult <- calcPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + ", mean=" + mean + "," + "sigma = " + this.dfp.getTable().getModel().getDataFrame().getRMatrix() + userDefinedF + ")");
        double[] localPower = RControl.getR().eval(".powerResult$LocalPower").asRNumeric().getData();
        double expRejections = RControl.getR().eval(".powerResult$ExpRejections").asRNumeric().getData()[0];
        double powAtlst1 = RControl.getR().eval(".powerResult$PowAtlst1").asRNumeric().getData()[0];
        double rejectAll = RControl.getR().eval(".powerResult$RejectAll").asRNumeric().getData()[0];
        Double userDefined = null;
        if (this.jtUserDefined.getText().length() > 1) {
            userDefined = RControl.getR().eval(".powerResult$userDefined").asRNumeric().getData()[0];
        }
        this.parent.getGraphView().getNL().setPower(localPower, expRejections, powAtlst1, rejectAll, userDefined);
        this.dispose();
    }
}

