/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.options;

import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.af.commons.Localizer;
import org.af.commons.widgets.validate.IntegerTextField;
import org.af.commons.widgets.validate.RealTextField;
import org.af.commons.widgets.validate.ValidationException;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.config.PlotConfig;
import org.af.gMCP.gui.options.OptionsPanel;

public class MiscPanel
extends OptionsPanel {
    private RealTextField tfWidth;
    private RealTextField tfHeight;
    private RealTextField tfWidthInch;
    private RealTextField tfHeightInch;
    private IntegerTextField tfPointSize;
    private IntegerTextField tfTNWidth;
    private Configuration conf;

    public MiscPanel(Configuration conf) {
        this.conf = conf;
        this.makeComponents();
        this.doTheLayout();
    }

    private void makeComponents() {
        PlotConfig pc = this.conf.getPlotConfig();
        Localizer loc = Localizer.getInstance();
        this.tfWidth = new RealTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_WIDTH"), 5, 2.0, 1000.0);
        this.tfWidth.setText("" + pc.getWidth());
        this.tfHeight = new RealTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_HEIGHT"), 5, 2.0, 1000.0);
        this.tfHeight.setText("" + pc.getHeight());
        this.tfWidthInch = new RealTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_WIDTHINCH"), 5, 0.1, 100.0);
        this.tfWidthInch.setText("" + pc.getWidthInch());
        this.tfHeightInch = new RealTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_HEIGHTINCH"), 5, 0.1, 100.0);
        this.tfHeightInch.setText("" + pc.getHeightInch());
        this.tfPointSize = new IntegerTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_POINTSIZE"), 5, 2, 20);
        this.tfPointSize.setText("" + pc.getPointSize());
        this.tfTNWidth = new IntegerTextField(loc.getString("SGTK_OPTIONS_PLOTPANEL_THUMBNAILWIDTH"), 5, 50, 300);
        this.tfTNWidth.setText("" + pc.getTNWidth());
    }

    private void doTheLayout() {
        Localizer loc = Localizer.getInstance();
        JPanel p1 = new JPanel();
        String cols = "pref, 5dlu, fill:pref:grow";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref";
        FormLayout layout = new FormLayout(cols, rows);
        p1.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        int row = 1;
        p1.add((Component)DefaultComponentFactory.getInstance().createSeparator(loc.getString("SGTK_OPTIONS_PLOTPANEL_PLOTFILESEP")), cc.xyw(1, row, 3));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_WIDTH")), cc.xy(1, row += 2));
        p1.add((Component)this.tfWidth, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_HEIGHT")), cc.xy(1, row += 2));
        p1.add((Component)this.tfHeight, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_WIDTHINCH")), cc.xy(1, row += 2));
        p1.add((Component)this.tfWidthInch, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_HEIGHTINCH")), cc.xy(1, row += 2));
        p1.add((Component)this.tfHeightInch, cc.xy(3, row));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_POINTSIZE")), cc.xy(1, row += 2));
        p1.add((Component)this.tfPointSize, cc.xy(3, row));
        p1.add((Component)DefaultComponentFactory.getInstance().createSeparator(loc.getString("SGTK_OPTIONS_PLOTPANEL_THUMBNAILSEP")), cc.xyw(1, row += 2, 3));
        p1.add((Component)new JLabel(loc.getString("SGTK_OPTIONS_PLOTPANEL_THUMBNAILWIDTH")), cc.xy(1, row += 2));
        p1.add((Component)this.tfTNWidth, cc.xy(3, row));
        this.add(p1);
    }

    public void setProperties() throws ValidationException {
        double width = (Double)this.tfWidth.getValidatedValue();
        double height = (Double)this.tfHeight.getValidatedValue();
        double widthi = (Double)this.tfWidthInch.getValidatedValue();
        double heighti = (Double)this.tfHeightInch.getValidatedValue();
        int pointSize = (Integer)this.tfPointSize.getValidatedValue();
        int tnWidth = (Integer)this.tfTNWidth.getValidatedValue();
        PlotConfig pc = this.conf.getPlotConfig();
        pc.setWidth(width);
        pc.setHeight(height);
        pc.setWidthInch(widthi);
        pc.setHeightInch(heighti);
        pc.setPointSize(pointSize);
        pc.setTNWidth(tnWidth);
    }
}

