/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.RControl;
import org.mutoss.gui.dialogs.VariableDialog;
import org.mutoss.gui.graph.Edge;
import org.mutoss.gui.graph.EdgeWeight;
import org.mutoss.gui.graph.GraphMCP;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.Node;
import org.mutoss.gui.graph.UpdateEdge;
import org.mutoss.gui.graph.UpdateNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetList
extends JPanel
implements MouseMotionListener,
MouseListener {
    private static final Log logger = LogFactory.getLog(NetList.class);
    GraphView control;
    int drag = -1;
    int edrag = -1;
    protected Vector<Edge> edges = new Vector();
    protected Vector<Node> nodes = new Vector();
    Node firstVertex;
    boolean firstVertexSelected = false;
    public String initialGraph = ".InitialGraph" + new Date().getTime();
    boolean newEdge = false;
    boolean newVertex = false;
    JLabel statusBar;
    public boolean testingStarted = false;
    double zoom = 1.0;
    public boolean updateGUI = true;

    public NetList(JLabel statusBar, GraphView graphview) {
        this.statusBar = statusBar;
        this.control = graphview;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        Font f = statusBar.getFont();
        statusBar.setFont(f.deriveFont(f.getStyle() ^ 1));
    }

    public void acceptNode(Node node) {
        this.control.getPView().savePValues();
        this.saveGraph(".tmpGraph", false);
        RControl.getR().eval(".tmpGraph <- substituteEps(.tmpGraph, eps=" + Configuration.getInstance().getGeneralConfig().getEpsilon() + ")");
        RControl.getR().eval(".tmpGraph <- rejectNode(.tmpGraph, \"" + node.getName() + "\")");
        this.reset();
        new GraphMCP(".tmpGraph", this);
        this.control.getPView().restorePValues();
    }

    public void addDefaultNode(int x, int y) {
        int i = this.nodes.size() + 1;
        String name = "H" + i;
        while (this.whichNode(name) != -1) {
            name = "H" + ++i;
        }
        this.addNode(new Node(name, x, y, 0.0, this));
    }

    public void addEdge(Edge e) {
        Edge old = null;
        for (Edge e2 : this.edges) {
            if (e2.from == e.from && e2.to == e.to) {
                old = e2;
            }
            if (e2.from != e.to || e2.to != e.from) continue;
            e.curve = true;
            e2.curve = true;
        }
        if (old != null) {
            this.edges.remove(old);
        }
        this.edges.add(e);
        this.control.getDataTable().getModel().setValueAt(e.getEdgeWeight(), this.getKnoten().indexOf(e.from), this.getKnoten().indexOf(e.to));
        this.graphHasChanged();
    }

    public void addEdge(Node von, Node nach) {
        this.addEdge(von, nach, 1.0);
    }

    public void addEdge(Node von, Node nach, Double w) {
        this.addEdge(von, nach, new EdgeWeight(w));
    }

    public void addEdge(Node von, Node nach, EdgeWeight w) {
        Integer x = null;
        Integer y = null;
        boolean curve = false;
        for (Edge e : this.edges) {
            if (e.from != nach || e.to != von) continue;
            e.curve = true;
            curve = true;
        }
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            if (this.edges.get((int)i).from != von || this.edges.get((int)i).to != nach) continue;
            x = this.edges.get(i).getK1();
            y = this.edges.get(i).getK2();
            this.edges.remove(i);
        }
        if (!w.toString().equals("0")) {
            if (x != null) {
                this.edges.add(new Edge(von, nach, w, this, (int)x, (int)y));
            } else {
                this.edges.add(new Edge(von, nach, w, this, curve));
            }
            this.edges.lastElement().curve = curve;
        }
        this.control.getDataTable().getModel().setValueAt(w, this.getKnoten().indexOf(von), this.getKnoten().indexOf(nach));
        this.graphHasChanged();
    }

    public void addNode(Node node) {
        this.control.enableButtons(true);
        this.nodes.add(node);
        this.control.getPView().addPPanel(node);
        this.control.getDataTable().getModel().addRowCol(node.getName());
        this.calculateSize();
        this.graphHasChanged();
    }

    public void graphHasChanged() {
        this.control.resultUpToDate = false;
        if (!this.updateGUI) {
            return;
        }
        String analysis = null;
        Set<String> variables = this.getAllVariables();
        variables.remove("\u03b5");
        if (variables.size() == 0) {
            try {
                String graphName = ".tmpGraph" + new Date().getTime();
                this.saveGraph(graphName, false);
                analysis = RControl.getR().eval("graphAnalysis(" + graphName + ", file=tempfile())").asRChar().getData()[0];
            }
            catch (Exception exception) {}
        } else {
            analysis = "Graphs with variables are not yet supported for analysis.";
        }
        this.control.getDView().setAnalysis(analysis);
    }

    public int[] calculateSize() {
        int i;
        int maxX = 0;
        int maxY = 0;
        for (i = 0; i < this.nodes.size(); ++i) {
            if (this.nodes.get(i).getX() > maxX) {
                maxX = this.nodes.get(i).getX();
            }
            if (this.nodes.get(i).getY() <= maxY) continue;
            maxY = this.nodes.get(i).getY();
        }
        for (i = 0; i < this.edges.size(); ++i) {
            if (this.edges.get(i).getK1() > maxX) {
                maxX = this.edges.get(i).getK1();
            }
            if (this.edges.get(i).getK2() <= maxY) continue;
            maxY = this.edges.get(i).getK2();
        }
        this.setPreferredSize(new Dimension((int)((double)(maxX + 2 * Node.getRadius() + 30) * this.getZoom()), (int)((double)(maxY + 2 * Node.getRadius() + 30) * this.getZoom())));
        if (this.updateGUI) {
            this.revalidate();
            this.repaint();
        }
        return new int[]{maxX, maxY};
    }

    public Edge findEdge(Node von, Node nach) {
        for (Edge e : this.edges) {
            if (von != e.from || nach != e.to) continue;
            return e;
        }
        return null;
    }

    public Vector<Edge> getEdges() {
        return this.edges;
    }

    public BufferedImage getImage() {
        long maxX = 0L;
        long maxY = 0L;
        for (Node node : this.nodes) {
            if ((long)node.getX() > maxX) {
                maxX = node.getX();
            }
            if ((long)node.getY() <= maxY) continue;
            maxY = node.getY();
        }
        for (Edge edge : this.edges) {
            if ((long)edge.getK1() > maxX) {
                maxX = edge.getK1();
            }
            if ((long)edge.getK2() <= maxY) continue;
            maxY = edge.getK2();
        }
        BufferedImage img = new BufferedImage((int)((double)(maxX + (long)(2 * Node.getRadius()) + 10L) * this.getZoom()), (int)((double)(maxY + (long)(2 * Node.getRadius()) + 10L) * this.getZoom()), 2);
        Graphics2D g = img.createGraphics();
        g.setStroke(new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
        return img;
    }

    public Vector<Node> getKnoten() {
        return this.nodes;
    }

    public String getLaTeX() {
        int i;
        DecimalFormat format = Configuration.getInstance().getGeneralConfig().getDecFormat();
        String latex = "";
        double scale = 0.5;
        latex = latex + "\\begin{tikzpicture}[scale=" + scale + "]";
        for (i = 0; i < this.getKnoten().size(); ++i) {
            Node node = this.getKnoten().get(i);
            latex = latex + "\\node (" + node.getName().replace("_", "-") + ") at (" + node.getX() + "bp," + -node.getY() + "bp)\n";
            String nodeColor = "green!80";
            if (node.isRejected()) {
                nodeColor = "red!80";
            }
            latex = latex + "[draw,circle split,fill=" + nodeColor + "] {$" + node.getName() + "$ \\nodepart{lower} $" + format.format(node.getWeight()) + "$};\n";
        }
        for (i = 0; i < this.getEdges().size(); ++i) {
            Node node1 = this.getEdges().get((int)i).from;
            Node node2 = this.getEdges().get((int)i).to;
            String to = "bend left=" + this.getEdges().get(i).getBendLeft();
            String weight = this.getEdges().get(i).getWLaTeX();
            String pos = format.format(this.getEdges().get(i).getPos()).replace(",", ".");
            latex = latex + "\\draw [->,line width=1pt] (" + node1.getName().replace("_", "-") + ") to[" + to + "] node[pos=" + pos + ",above,fill=blue!20] {" + weight + "} (" + node2.getName().replace("_", "-") + ");\n";
        }
        latex = latex + "\\end{tikzpicture}\n\n";
        return latex;
    }

    public double getZoom() {
        return this.zoom;
    }

    public boolean isTesting() {
        return this.testingStarted;
    }

    public void loadGraph() {
        this.control.stopTesting();
        this.reset();
        this.updateGUI = false;
        GraphMCP graph = new GraphMCP(this.initialGraph, this);
        if (graph.getDescription() != null) {
            this.control.getDView().setDescription(graph.getDescription());
        } else {
            this.control.getDView().setDescription("");
        }
        this.control.getPView().restorePValues();
        this.updateGUI = true;
        this.graphHasChanged();
        this.revalidate();
        this.repaint();
    }

    public void loadGraph(String string) {
        boolean matrix = RControl.getR().eval("is.matrix(" + string + ")").asRLogical().getData()[0];
        RControl.getR().eval(this.initialGraph + " <- placeNodes(" + (matrix ? "matrix2graph(" : "(") + string + "))");
        this.loadGraph();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.drag == -1 && this.edrag == -1) {
            return;
        }
        if (this.drag != -1) {
            this.nodes.get(this.drag).setX((int)(((double)e.getX() - (double)Node.getRadius() * this.getZoom()) / this.getZoom()));
            this.nodes.get(this.drag).setY((int)(((double)e.getY() - (double)Node.getRadius() * this.getZoom()) / this.getZoom()));
        } else {
            this.edges.get(this.edrag).setK1((int)((double)e.getX() / this.getZoom()));
            this.edges.get(this.edrag).setK2((int)((double)e.getY() / this.getZoom()));
        }
        this.calculateSize();
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int i;
        logger.debug((Object)("MousePressed at (" + e.getX() + "," + e.getY() + ")."));
        if (this.newVertex) {
            this.addDefaultNode((int)((double)e.getX() / this.getZoom()) - Node.r, (int)((double)e.getY() / this.getZoom()) - Node.r);
            this.newVertex = false;
            this.statusBar.setText("Place new nodes and edges or start the test procedure");
            this.repaint();
            return;
        }
        if (this.newEdge) {
            if (!this.firstVertexSelected) {
                this.firstVertex = this.vertexSelected(e.getX(), e.getY());
                if (this.firstVertex == null) {
                    return;
                }
                this.firstVertexSelected = true;
                this.statusBar.setText("Select a second node to which the edge should lead.");
            } else {
                Node secondVertex = this.vertexSelected(e.getX(), e.getY());
                if (secondVertex == null || secondVertex == this.firstVertex) {
                    return;
                }
                this.addEdge(this.firstVertex, secondVertex);
                this.newEdge = false;
                this.firstVertexSelected = false;
                this.statusBar.setText("Place new nodes and edges or start the test procedure");
            }
            this.repaint();
            return;
        }
        if (this.drag == -1) {
            for (i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                this.drag = i;
            }
            if (this.drag != -1) {
                this.nodes.get((int)this.drag).drag = true;
            }
        }
        if (this.drag == -1 && this.edrag == -1) {
            for (i = 0; i < this.edges.size(); ++i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                this.edrag = i;
            }
        }
        if (e.getClickCount() == 2 && !this.testingStarted) {
            for (i = 0; i < this.nodes.size(); ++i) {
                if (!this.nodes.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateNode(this.nodes.get(i), this);
            }
            for (i = 0; i < this.edges.size(); ++i) {
                if (!this.edges.get(i).inYou(e.getX(), e.getY())) continue;
                new UpdateEdge(this.edges.get(i), this, this.control);
            }
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.drag != -1) {
            this.nodes.get(this.drag).setX((int)(((double)e.getX() - (double)Node.getRadius() * this.getZoom()) / this.getZoom()));
            this.nodes.get(this.drag).setY((int)(((double)e.getY() - (double)Node.getRadius() * this.getZoom()) / this.getZoom()));
            this.calculateSize();
            this.nodes.get((int)this.drag).drag = false;
            this.drag = -1;
            this.repaint();
        }
        if (this.edrag != -1) {
            this.edges.get(this.edrag).setK1((int)((double)e.getX() / this.getZoom()));
            this.edges.get(this.edrag).setK2((int)((double)e.getY() / this.getZoom()));
            this.calculateSize();
            this.edrag = -1;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int grid = Configuration.getInstance().getGeneralConfig().getGridSize();
        g.setColor(Color.LIGHT_GRAY);
        if (grid > 1) {
            for (int x = -Node.r / grid * grid; x < this.getWidth(); x += grid) {
                g.drawLine(x + Node.r, 0, x + Node.r, this.getHeight());
            }
            for (int y = -Node.r / grid * grid; y < this.getHeight(); y += grid) {
                g.drawLine(0, y + Node.r, this.getWidth(), y + Node.r);
            }
        }
        BasicStroke stroke = new BasicStroke(Configuration.getInstance().getGeneralConfig().getLineWidth());
        ((Graphics2D)g).setStroke(stroke);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (Node node : this.nodes) {
            node.paintYou(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdge(g);
        }
        for (Edge edge : this.edges) {
            edge.paintEdgeLabel(g);
        }
    }

    public void refresh() {
        this.calculateSize();
        this.revalidate();
        this.repaint();
    }

    public void removeEdge(Edge edge) {
        for (Edge e : this.edges) {
            if (e.from != edge.to || e.to != edge.from) continue;
            e.curve = false;
        }
        this.edges.remove(edge);
        this.control.getDataTable().getModel().setValueAt(new EdgeWeight(0.0), this.getKnoten().indexOf(edge.from), this.getKnoten().indexOf(edge.to));
        this.graphHasChanged();
    }

    public void removeNode(Node node) {
        for (int i = this.edges.size() - 1; i >= 0; --i) {
            Edge e = this.edges.get(i);
            if (e.from != node && e.to != node) continue;
            this.edges.remove(e);
        }
        this.control.getDataTable().getModel().delRowCol(this.getKnoten().indexOf(node));
        this.nodes.remove(node);
        this.control.getPView().removePPanel(node);
        if (this.nodes.size() == 0) {
            this.control.enableButtons(false);
        }
        this.repaint();
        this.graphHasChanged();
    }

    public void reset() {
        this.edges.removeAllElements();
        for (int i = this.getKnoten().size() - 1; i >= 0; --i) {
            this.removeNode(this.getKnoten().get(i));
        }
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
        this.firstVertexSelected = false;
        this.newVertex = false;
        this.newEdge = false;
        this.zoom = 1.0;
        this.graphHasChanged();
    }

    public void saveGraph() {
        this.saveGraph(this.initialGraph, false);
        this.control.getPView().savePValues();
    }

    public Set<String> getAllVariables() {
        HashSet<String> variables = new HashSet<String>();
        for (Edge e : this.edges) {
            variables.addAll(e.getVariable());
        }
        return variables;
    }

    public String saveGraphWithoutVariables(String graphName, boolean verbose) {
        Set<String> variables = this.getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        Hashtable<String, Double> ht = new Hashtable<String, Double>();
        if (!(variables.isEmpty() || variables.size() == 1 && variables.contains("\u03b5"))) {
            VariableDialog vd = new VariableDialog(this.control.parent, variables);
            ht = vd.getHT();
        } else if (variables.size() == 1 && variables.contains("\u03b5")) {
            ht.put("\u03b5", Configuration.getInstance().getGeneralConfig().getEpsilon());
        }
        return this.saveGraph(graphName, verbose, ht);
    }

    public String saveGraph(String graphName, boolean verbose) {
        return this.saveGraph(graphName, verbose, new Hashtable<String, Double>());
    }

    public String saveGraph(String graphName, boolean verbose, Hashtable<String, Double> ht) {
        int i;
        Node n2;
        graphName = RControl.getR().eval("make.names(\"" + graphName + "\")").asRChar().getData()[0];
        String alpha = "";
        String nodeStr = "";
        String x = "";
        String y = "";
        for (Node n2 : this.nodes) {
            alpha = alpha + n2.getWeight() + ",";
            nodeStr = nodeStr + "\"" + n2.getName() + "\",";
            x = x + n2.getX() + ",";
            y = y + n2.getY() + ",";
        }
        alpha = alpha.substring(0, alpha.length() - 1);
        nodeStr = nodeStr.substring(0, nodeStr.length() - 1);
        x = x.substring(0, x.length() - 1);
        y = y.substring(0, y.length() - 1);
        RControl.getR().evalVoid(".gsrmtVar <- list()");
        RControl.getR().evalVoid(".gsrmtVar$alpha <- c(" + alpha + ")");
        RControl.getR().evalVoid(".gsrmtVar$hnodes <- c(" + nodeStr + ")");
        RControl.getR().evalVoid(".gsrmtVar$edges <- vector(\"list\", length=" + this.nodes.size() + ")");
        RControl.getR().evalVoid("names(.gsrmtVar$edges)<-.gsrmtVar$hnodes");
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            n2 = this.nodes.get(i);
            String edgeL = "";
            String weights = "";
            for (Edge e : this.edges) {
                if (e.from != n2) continue;
                edgeL = edgeL + "\"" + e.to.getName() + "\",";
                weights = weights + e.getW(ht)[0] + ",";
            }
            if (edgeL.length() != 0) {
                edgeL = edgeL.substring(0, edgeL.length() - 1);
                weights = weights.substring(0, weights.length() - 1);
                RControl.getR().evalVoid(".gsrmtVar$edges[[" + (i + 1) + "]] <- list(edges=c(" + edgeL + "), weights=c(" + weights + "))");
                continue;
            }
            RControl.getR().evalVoid(".gsrmtVar$edges[[" + (i + 1) + "]] <- list(edges=character(0), weights=numeric(0))");
        }
        RControl.getR().evalVoid(graphName + " <- new(\"graphMCP\", nodes=.gsrmtVar$hnodes, edgeL=.gsrmtVar$edges, weights=.gsrmtVar$alpha)");
        RControl.getR().evalVoid(graphName + " <- gMCP:::stupidWorkAround(" + graphName + ")");
        for (i = this.nodes.size() - 1; i >= 0; --i) {
            n2 = this.nodes.get(i);
            if (!n2.isRejected()) continue;
            RControl.getR().evalVoid("nodeData(" + graphName + ", \"" + n2.getName() + "\", \"rejected\") <- TRUE");
        }
        RControl.getR().evalVoid(".gsrmtVar$nodeX <- c(" + x + ")");
        RControl.getR().evalVoid(".gsrmtVar$nodeY <- c(" + y + ")");
        RControl.getR().evalVoid("names(.gsrmtVar$nodeX) <- .gsrmtVar$hnodes");
        RControl.getR().evalVoid("names(.gsrmtVar$nodeY) <- .gsrmtVar$hnodes");
        RControl.getR().evalVoid("nodeRenderInfo(" + graphName + ") <- list(nodeX=.gsrmtVar$nodeX, nodeY=.gsrmtVar$nodeY)");
        for (Edge e : this.edges) {
            RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelX\") <- " + (e.k1 - Node.getRadius()));
            RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"labelY\") <- " + (e.k2 - Node.getRadius()));
            String eps = e.getEpsilonString(null);
            if (eps != null) {
                RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"epsilon\") <- list(" + eps + ")");
            }
            logger.debug((Object)("Weight is: " + e.getW(ht)[0]));
            if (!Double.valueOf(e.getW(ht)[0]).isNaN()) continue;
            RControl.getR().evalVoid("edgeData(" + graphName + ", \"" + e.from.getName() + "\", \"" + e.to.getName() + "\", \"variableWeight\") <- \"" + e.getWS().replaceAll("\\\\", "\\\\\\\\") + "\"");
        }
        RControl.getR().evalVoid("attr(" + graphName + ", \"description\") <- \"" + this.control.getDView().getDescription() + "\"");
        if (verbose) {
            JOptionPane.showMessageDialog(null, "The graph as been exported to R under ther variable name:\n\n" + graphName, "Saved as \"" + graphName + "\"", 1);
        }
        return graphName;
    }

    public void setEdges(Vector<Edge> edges) {
        this.edges = edges;
        this.graphHasChanged();
    }

    public void setKnoten(Vector<Node> knoten) {
        this.nodes = knoten;
        this.graphHasChanged();
    }

    public void setZoom(double p) {
        this.zoom = p;
    }

    public void startTesting() {
        this.testingStarted = true;
        this.statusBar.setText("Reject nodes or reset to the initial graph for modifications.");
    }

    public void stopTesting() {
        this.testingStarted = false;
        this.statusBar.setText("Place new nodes and edges or start the test procedure");
    }

    public Node vertexSelected(int x, int y) {
        for (Node n : this.nodes) {
            if (!n.inYou(x, y)) continue;
            return n;
        }
        return null;
    }

    public int whichNode(String name) {
        for (int i = 0; i < this.nodes.size(); ++i) {
            if (!this.nodes.get(i).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }
}

