/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui.datatable;

import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.gui.graph.EdgeWeight;

public class RDataFrameRef {
    private static final Log logger = LogFactory.getLog(RDataFrameRef.class);
    List<String> rcNames = new Vector<String>();
    Vector<Vector<EdgeWeight>> data = new Vector();

    public String getColName(int col) {
        return this.rcNames.get(col);
    }

    public String getRowName(int row) {
        return this.rcNames.get(row);
    }

    public void setValue(int row, int col, EdgeWeight value) {
        this.data.get(row).set(col, value);
    }

    public EdgeWeight getElement(int row, int col) {
        return this.data.get(row).get(col);
    }

    public void delRowCol(int col) {
        this.rcNames.remove(col);
        this.data.remove(col);
        for (Vector<EdgeWeight> v : this.data) {
            v.remove(col);
        }
    }

    public int getRowCount() {
        return this.data.size();
    }

    public int getColumnCount() {
        return this.data.size();
    }

    public void addRowCol(String name) {
        int i;
        this.rcNames.add(name);
        Vector<EdgeWeight> row = new Vector<EdgeWeight>();
        for (i = 0; i < this.getColumnCount(); ++i) {
            row.add(new EdgeWeight(0.0));
        }
        this.data.add(row);
        for (i = 0; i < this.getRowCount(); ++i) {
            this.data.get(i).add(new EdgeWeight(0.0));
        }
        logger.info((Object)("Data has " + this.getRowCount() + " rows and " + this.getColumnCount() + " columns now."));
    }
}

