/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.widgets.InfiniteProgressPanel;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.config.Configuration;
import org.mutoss.gui.MenuBarMGraph;
import org.mutoss.gui.RControl;
import org.mutoss.gui.datatable.CellEditorE;
import org.mutoss.gui.datatable.DataFramePanel;
import org.mutoss.gui.datatable.DataTable;
import org.mutoss.gui.datatable.RDataFrameRef;
import org.mutoss.gui.graph.DView;
import org.mutoss.gui.graph.EdgeWeight;
import org.mutoss.gui.graph.GraphView;
import org.mutoss.gui.graph.PView;
import org.rosuda.REngine.JRI.JRIEngine;

public class CreateGraphGUI
extends JFrame
implements WindowListener,
InfiniteProgressPanel.AbortListener {
    GraphView agc;
    PView pview;
    DView dview;
    DataFramePanel dfp;
    public InfiniteProgressPanel glassPane;
    protected static Log logger = LogFactory.getLog(CreateGraphGUI.class);
    static String graphStr;
    static boolean debug;
    static double grid;
    JSplitPane splitPane;
    JSplitPane splitPane1;
    JSplitPane splitPane2;

    public CreateGraphGUI(String graph, double[] pvalues, boolean debug, double grid) {
        super("gMCP GUI");
        Locale.setDefault(Locale.US);
        JComponent.setDefaultLocale(Locale.US);
        RControl.getRControl(debug);
        Localizer.getInstance().addResourceBundle("org.mutoss.gui.ResourceBundle");
        if (grid > 0.0) {
            Configuration.getInstance().getGeneralConfig().setGridSize((int)grid);
        }
        try {
            Configuration.getInstance().getGeneralConfig().setVersionNumber(RControl.getR().eval("gMCP:::gMCPVersion()").asRChar().getData()[0]);
        }
        catch (Exception e) {
            logger.warn((Object)("Package version could not be set:\n" + e.getMessage()));
        }
        Configuration.getInstance().getGeneralConfig().setNumberOfStarts(Configuration.getInstance().getGeneralConfig().getNumberOfStarts() + 1);
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/gui/graph/images/rjavaicon64.png")).getImage());
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.addWindowListener(this);
        this.pview = new PView(this);
        this.dview = new DView(this);
        this.dfp = new DataFramePanel(new RDataFrameRef());
        this.agc = new GraphView(graph, this);
        this.setJMenuBar(new MenuBarMGraph(this.agc));
        this.makeContent();
        this.agc.getNL().loadGraph(graph);
        if (pvalues.length > 0) {
            this.getPView().setPValues(ArrayUtils.toObject((double[])pvalues));
        }
        this.glassPane = new InfiniteProgressPanel((JFrame)this, "Calculating");
        this.setGlassPane((Component)this.glassPane);
        this.glassPane.addAbortListener((InfiniteProgressPanel.AbortListener)this);
        this.setVisible(true);
        this.splitPane1.setDividerLocation(0.75);
        this.splitPane2.setDividerLocation(0.5);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    logger.warn((Object)("Interrupted: " + e.getMessage()), (Throwable)e);
                }
                CreateGraphGUI.this.splitPane1.setDividerLocation(0.75);
                CreateGraphGUI.this.splitPane2.setDividerLocation(0.5);
            }
        });
    }

    public static void startGUI(String graphStr, boolean debug, double grid) {
        CreateGraphGUI.graphStr = graphStr;
        CreateGraphGUI.debug = debug;
        CreateGraphGUI.grid = grid;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                new CreateGraphGUI(graphStr, new double[0], debug, grid);
            }
        });
    }

    private void makeContent() {
        this.dfp.getTable().setDefaultEditor(EdgeWeight.class, new CellEditorE(this.agc));
        this.splitPane1 = new JSplitPane(0, this.agc, this.dview);
        this.splitPane2 = new JSplitPane(0, new JScrollPane(this.dfp), new JScrollPane(this.pview));
        this.splitPane = new JSplitPane(1, this.splitPane1, this.splitPane2);
        this.getContentPane().add(this.splitPane);
    }

    public static void main(String[] args) {
        new CreateGraphGUI("graph", new double[0], true, 10.0);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public PView getPView() {
        return this.pview;
    }

    public GraphView getGraphView() {
        return this.agc;
    }

    public DataTable getDataTable() {
        return this.dfp.getTable();
    }

    public void abort() {
        if (RControl.getR().getREngine().getClass() == JRIEngine.class) {
            JRIEngine engine = (JRIEngine)RControl.getR().getREngine();
            engine.getRni().rniStop(0);
            try {
                RControl.getR().eval("rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.warn((Object)("There was an error in the test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
            }
            try {
                RControl.getR().eval("rmvnorm(n=5, mean=c(1,2), sigma=matrix(c(4,2,2,3), ncol=2))");
            }
            catch (Exception e) {
                logger.error((Object)("There was an error in the 2. test eval after interrupt:\n" + e.getMessage()), (Throwable)e);
                String message = "There was an error interrupting the R calculation.\nAfter you press okay an error dialog will open and please inform us about this.\nAfter that we recommend that you close the GUI (but you can try whether saving of graphs or other things work).";
                JOptionPane.showMessageDialog(this, message, "Error interrupting R calculation", 0);
                ErrorHandler.getInstance().makeErrDialog("");
            }
        } else {
            logger.error((Object)("Could not stop REngine of class '" + RControl.getR().getREngine().getClass() + "'"));
        }
    }

    public DView getDView() {
        return this.dview;
    }
}

