/*
 * Decompiled with CFR 0.152.
 */
package org.af.jhlir.backends.rengine;

import java.rmi.RemoteException;
import java.util.List;
import java.util.Random;
import org.af.jhlir.backends.rengine.RCharREngine;
import org.af.jhlir.backends.rengine.RDataFrameREngine;
import org.af.jhlir.backends.rengine.RDataFrameRefREngine;
import org.af.jhlir.backends.rengine.REnvironmentREngine;
import org.af.jhlir.backends.rengine.RFactorREngine;
import org.af.jhlir.backends.rengine.RIntegerREngine;
import org.af.jhlir.backends.rengine.RListREngine;
import org.af.jhlir.backends.rengine.RListRefREngine;
import org.af.jhlir.backends.rengine.RLogicalREngine;
import org.af.jhlir.backends.rengine.RMatrixDoubleREngine;
import org.af.jhlir.backends.rengine.RNumericREngine;
import org.af.jhlir.backends.rengine.RObjectREngine;
import org.af.jhlir.backends.rengine.S3ObjREngine;
import org.af.jhlir.call.RCallServices;
import org.af.jhlir.call.RChar;
import org.af.jhlir.call.RErrorException;
import org.af.jhlir.call.RInteger;
import org.af.jhlir.call.RLogical;
import org.af.jhlir.call.RNamedArgument;
import org.af.jhlir.call.RNumeric;
import org.af.jhlir.call.RObj;
import org.af.jhlir.call.RRef;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPDouble;
import org.rosuda.REngine.REXPEnvironment;
import org.rosuda.REngine.REXPFactor;
import org.rosuda.REngine.REXPGenericVector;
import org.rosuda.REngine.REXPInteger;
import org.rosuda.REngine.REXPLogical;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REXPReference;
import org.rosuda.REngine.REXPString;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class RCallServicesREngine
extends RCallServices {
    private REngine rs;
    private REXP globalEnv;

    public RCallServicesREngine(REngine rs) {
        this.rs = rs;
        try {
            this.globalEnv = rs.parseAndEval(".GlobalEnv");
        }
        catch (REngineException e) {
            e.printStackTrace();
        }
        catch (REXPMismatchException e) {
            e.printStackTrace();
        }
        try {
            rs.parseAndEval("options(error = function() {.jhlir.errors<<- geterrmessage()})");
        }
        catch (REngineException e) {
            throw new org.af.jhlir.call.REngineException(e);
        }
        catch (REXPMismatchException e) {
            throw new org.af.jhlir.call.REngineException(e);
        }
    }

    public REngine getREngine() {
        return this.rs;
    }

    public void evalVoid(String expression) throws org.af.jhlir.call.REngineException {
        this.engineEval(expression, true);
    }

    public RObj eval(String expression) throws org.af.jhlir.call.REngineException {
        REXP robj = this.engineEval(expression, true);
        return this.wrapObject(robj);
    }

    public RRef evalAndGetRef(String expression) throws org.af.jhlir.call.REngineException {
        REXPReference rr = (REXPReference)this.engineEval(expression, false);
        return this.wrapObject(rr);
    }

    public REXP engineEval(String expression, boolean resolve) {
        try {
            this.rs.parseAndEval(".jhlir.errors <<- NULL");
            String expression2 = expression.replace("\"", "\\\"");
            String s1 = "parse(text=\"" + expression2 + "\")";
            System.out.println(s1);
            REXP rexp = this.rs.parseAndEval(s1);
            REXP errRexp = this.rs.parseAndEval(".jhlir.errors");
            if (!(errRexp instanceof REXPNull)) {
                String error = errRexp.asString();
                throw new RErrorException(error);
            }
            REXP res = this.rs.parseAndEval(expression, this.globalEnv, resolve);
            errRexp = this.rs.parseAndEval(".jhlir.errors");
            if (!(errRexp instanceof REXPNull)) {
                String error = errRexp.asString();
                throw new RErrorException(error);
            }
            return res;
        }
        catch (REngineException e) {
            e.printStackTrace();
        }
        catch (REXPMismatchException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public void assign(String varName, String expression) throws RemoteException {
        this.evalVoid(varName + "<-" + expression);
    }

    public RObj call(String function, Object ... args) {
        String argStr = "";
        for (Object o : args) {
            argStr = argStr + this.getString(o) + ",";
        }
        if (argStr.length() > 1) {
            argStr = argStr.substring(0, argStr.length() - 1);
        }
        return this.eval(function + "(" + argStr + ")");
    }

    public String getString(Object o) {
        if (o instanceof RObjectREngine) {
            String tmpname = ".JHLIRtmp" + Math.abs(new Random().nextInt());
            this.put(tmpname, o);
            String result = this.eval("paste(capture.output(dput(" + tmpname + ")), collapse=\"\")").asRChar().getData()[0];
            return tmpname;
        }
        if (o instanceof RNamedArgument) {
            return ((RNamedArgument)o).getName() + "=" + this.getString(((RNamedArgument)o).getRobj());
        }
        if (o instanceof String) {
            return "\"" + (String)o + "\"";
        }
        if (o instanceof List && ((List)o).get(0) instanceof String) {
            List l = (List)o;
            String result = "c(\"" + l.get(0) + "\"";
            for (int i = 1; i < l.size(); ++i) {
                result = result + ", \"" + l.get(i) + "\"";
            }
            return result + ")";
        }
        return null;
    }

    public void put(String varName, Object obj) throws org.af.jhlir.call.REngineException {
        try {
            if (obj instanceof RObjectREngine) {
                this.rs.assign(varName, ((RObjectREngine)obj).getWrapped());
            }
        }
        catch (Exception e) {
            throw new org.af.jhlir.call.REngineException(e);
        }
    }

    public RRef wrapObject(REXPReference ref) {
        REXP robj = ref.resolve();
        if (robj instanceof REXPGenericVector) {
            if (robj.hasAttribute("class") && ((REXPString)robj.getAttribute("class")).asStrings()[0].equals("data.frame")) {
                return new RDataFrameRefREngine(this, ref);
            }
            return new RListRefREngine(this, ref);
        }
        return null;
    }

    public RObjectREngine wrapObject(REXP robj) {
        if (robj == null) {
            return null;
        }
        if (robj instanceof REXPDouble) {
            try {
                if (robj.hasAttribute("dim") && robj.getAttribute("dim").asIntegers().length == 2) {
                    return new RMatrixDoubleREngine(this, (REXPDouble)robj);
                }
            }
            catch (REXPMismatchException rEXPMismatchException) {
                // empty catch block
            }
            return new RNumericREngine(this, (REXPDouble)robj);
        }
        if (robj instanceof REXPFactor) {
            return new RFactorREngine(this, (REXPFactor)robj);
        }
        if (robj instanceof REXPInteger && !(robj instanceof REXPFactor)) {
            return new RIntegerREngine(this, (REXPInteger)robj);
        }
        if (robj instanceof REXPLogical) {
            return new RLogicalREngine(this, (REXPLogical)robj);
        }
        if (robj instanceof REXPString) {
            return new RCharREngine(this, (REXPString)robj);
        }
        if (robj instanceof REXPGenericVector) {
            if (robj.hasAttribute("class") && ((REXPString)robj.getAttribute("class")).asStrings()[0].equals("data.frame")) {
                return new RDataFrameREngine(this, (REXPGenericVector)robj);
            }
            if (robj.hasAttribute("class")) {
                return new S3ObjREngine(this, (REXPGenericVector)robj);
            }
            return new RListREngine(this, (REXPGenericVector)robj);
        }
        if (robj instanceof REXPEnvironment) {
            return new REnvironmentREngine(this, (REXPEnvironment)robj);
        }
        return null;
    }

    public String[] getWarning() {
        String[] warning;
        try {
            this.rs.parseAndEval("last.warning");
            warning = this.rs.parseAndEval("last.warning").asList().keys();
        }
        catch (Exception e) {
            throw new org.af.jhlir.call.REngineException(e);
        }
        if (warning.length > 0 && !warning[0].equals("NO_WARNING")) {
            return warning;
        }
        return null;
    }

    public RNumeric createRObject(double[] val) {
        return new RNumericREngine(this, new REXPDouble(val));
    }

    public RInteger createRObject(int[] val) {
        return new RIntegerREngine(this, new REXPInteger(val));
    }

    public RChar createRObject(String[] val) {
        return new RCharREngine(this, new REXPString(val));
    }

    public RLogical createRObject(boolean[] val) {
        return new RLogicalREngine(this, new REXPLogical(val));
    }

    static {
        RCallServices.NA_RINTEGER = Integer.MIN_VALUE;
        RCallServices.NA_RNUMERIC = Double.NaN;
        RCallServices.NA_RLOGICAL = null;
        RCallServices.NA_CHAR = "NA";
        RCallServices.NA_FACTOR = null;
    }
}

