% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fxTWAPLS.R
\name{sse.sample}
\alias{sse.sample}
\title{Function to calculate Sample Specific Errors}
\usage{
sse.sample(
  modern_taxa,
  modern_climate,
  fossil_taxa,
  trainfun,
  predictfun,
  nboot,
  nPLS,
  nsig,
  usefx,
  fx,
  cpus = 4,
  seed = NULL,
  test_mode = FALSE,
  test_it = 5
)
}
\arguments{
\item{modern_taxa}{the modern taxa abundance data, each row represents a
sampling site, each column represents a taxon.}

\item{modern_climate}{the modern climate value at each sampling site}

\item{fossil_taxa}{fossil taxa abundance data to reconstruct past climates,
each row represents a site to be reconstructed, each column represents a
taxon.}

\item{trainfun}{training function you want to use, either
\code{\link{WAPLS.w}} or \code{\link{TWAPLS.w}}}

\item{predictfun}{predict function you want to use: if \code{trainfun} is
\code{\link{WAPLS.w}}, then this should be \code{\link{WAPLS.predict.w}};
if \code{trainfun} is \code{\link{TWAPLS.w}}, then this should be
\code{\link{TWAPLS.predict.w}}}

\item{nboot}{the number of bootstrap cycles you want to use}

\item{nPLS}{the number of components to be extracted}

\item{nsig}{the significant number of components to use to reconstruct past
climates, this can be obtained from the cross-validation results.}

\item{usefx}{boolean flag on whether or not use \code{fx} correction.}

\item{fx}{the frequency of the climate value for \code{fx} correction: if
\code{usefx} is FALSE, this should be \code{NA}; otherwise, this should
be obtained from the \code{\link{fx}} function.}

\item{cpus}{number of CPUs for simultaneous iterations to execute, check
\code{parallel::detectCores()} for available CPUs on your machine.}

\item{seed}{seed for reproducibility}

\item{test_mode}{boolean flag to execute the function with a limited number
of iterations, \code{test_it}, for testing purposes only.}

\item{test_it}{number of iterations to use in the test mode}
}
\value{
the bootstrapped standard error for each site
}
\description{
Function to calculate Sample Specific Errors
}
\examples{
# Load modern pollen data
modern_pollen <- read.csv(system.file("extdata", 
                                      "Modern_Pollen_gdd_alpha_Tmin.csv", 
                                      package = "fxTWAPLS", 
                                      mustWork = TRUE))

# Extract taxa
taxaColMin <- which(colnames(modern_pollen) == "Abies")
taxaColMax <- which(colnames(modern_pollen) == "Zygophyllaceae")
taxa <- modern_pollen[, taxaColMin:taxaColMax]

# Get the frequency of each climate variable fx
fx_Tmin <- fxTWAPLS::fx(modern_pollen$Tmin, bin = 0.02)
fx_gdd <- fxTWAPLS::fx(modern_pollen$gdd, bin = 20)
fx_alpha <- fxTWAPLS::fx(modern_pollen$alpha, bin = 0.002)

# Load reconstruction data
Holocene <- read.csv(system.file("extdata", 
                                 "Holocene.csv", 
                                 package = "fxTWAPLS", 
                                 mustWork = TRUE), 
                     row.names = 1)
taxaColMin <- which(colnames(Holocene) == "Abies")
taxaColMax <- which(colnames(Holocene) == "Zygophyllaceae")
core <- Holocene[, taxaColMin:taxaColMax]

# MTCO
## fx
fit_Tmin <- fxTWAPLS::WAPLS.w(taxa, modern_pollen$Tmin, nPLS = 5)
## SSE
nboot <- 5 # Recommended 1000
### without fx
sse_Tmin_WAPLS <- fxTWAPLS::sse.sample(modern_taxa = taxa,
                                       modern_climate = modern_pollen$Tmin,
                                       fossil_taxa = core,
                                       trainfun = fxTWAPLS::WAPLS.w,
                                       predictfun = fxTWAPLS::WAPLS.predict.w,
                                       nboot = nboot,
                                       nPLS = 5,
                                       nsig = 3,
                                       usefx = FALSE,
                                       fx = NA,
                                       cpus = 2,
                                       seed = 1)
### with fx
sse_f_Tmin_WAPLS <- fxTWAPLS::sse.sample(modern_taxa = taxa,
                                         modern_climate = modern_pollen$Tmin,
                                         fossil_taxa = core,
                                         trainfun = fxTWAPLS::WAPLS.w,
                                         predictfun = fxTWAPLS::WAPLS.predict.w,
                                         nboot = nboot,
                                         nPLS = 5,
                                         nsig = 3,
                                         usefx = TRUE,
                                         fx = fx_Tmin,
                                         cpus = 2,
                                         seed = 1)

}
\seealso{
\code{\link{fx}}, \code{\link{TWAPLS.w}},
\code{\link{TWAPLS.predict.w}}, \code{\link{WAPLS.w}}, and
\code{\link{WAPLS.predict.w}}
}
