% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{check_params}
\alias{check_params}
\title{Check for input parameter errors}
\usage{
check_params(out, dataFolder, dataDirectories, citycsv, coordinateFilenames,
  tasFilenames, timeFilenames, IDheatwavesFunction, thresholdBoundaries,
  projectionBoundaries, referenceBoundaries, numDays, seasonal_months,
  absolute_thresholds)
}
\arguments{
\item{out}{Character string with pathway to directory to which
extreme event files will be written. This should be a pathname to a directory
on the user's local computer. If the directory already exists, it will
be overwritten by this function, so the user should either specify a
pathname for a directory that does not yet exist or be willing to
overwrite the existing directory. The parent directory of the specified
directory must exist.}

\item{dataFolder}{Character string with pathway to a directory with
climate projection data. This directory must have a specific structure--
see the \code{futureheatwaves} vignette for guidance on setting up this
directory.}

\item{dataDirectories}{A list object, with two elements, one for each of the
two subdirectories included in the main directory. Typically, these will
be separate directories of historical and projection experiments from
climate models. Each element of the list should be named with the name of
the subdirectory and should provide a numeric vector with the starting and
ending years of the data within each of the two subdirectories (e.g.,
\code{list("historical" = c(1990, 1999), "rcp85" = c(2060, 2079))}
for a \code{dataFolder} with historical experiment data for 1990 to 1999
and RCP8.5 projections for 2060 to 2079).}

\item{citycsv}{Character string giving the filepath to a
comma-separated (.csv) file with, for each study city, a unique city
identifier, latitude, and longitude. These values must be specified with
the column names \code{city}, \code{lat}, and \code{lon}. See the
\code{futureheatwaves} vignette for guidance on setting up this
file.}

\item{coordinateFilenames}{Character string the with filename of each
grid point location file. This filename should be identical for all
ensemble member subdirectories included in the \code{dataFolder} directory.
See the package vignette for an example of the required structure for this
file.}

\item{tasFilenames}{Character string the with filename of each climate
projection file. This filename should be identical for all ensemble
member subdirectories included in the \code{dataFolder} directory. See the
package vignette for an example of the required structure for this file.}

\item{timeFilenames}{Character string the with filename of each projection
dates file. This filename should be identical for all ensemble
member  subdirectories included in the \code{dataFolder} directory. See
the package vignette for an example of the required structure for this
file.}

\item{IDheatwavesFunction}{A character string with the name of the R function
to use to identify extreme events. This function may be a user-specified custom
function, but it must be loaded into the current R session. The
function name must be put in quotation marks. For more guidance on how to
write and use a custom function to identify extreme events, see the package
vignette for \code{futureheatwaves}.}

\item{thresholdBoundaries}{A numeric vector with the custom time boundaries
to be used to determine the threshold variable values for the extreme event
definition. The required format for this vector is c(start year, end
year), with the restriction that bounds must be contained within the
time boundaries of one of the two experiment subdirectories specified
by the \code{dataDirectories} argument in \code{\link{gen_hw_set}}.
The default value is 1990 to 1999.}

\item{projectionBoundaries}{A numeric vector with the custom time boundaries
for which the user wants to create extreme event projections. The required
format for this vector is c(start year, end year), with the restriction
that bounds must be contained within the time boundaries of one of the two
experiment subdirectories specified by the \code{dataDirectories} argument
in \code{\link{gen_hw_set}}. The default value is 2070 to 2079.}

\item{referenceBoundaries}{A numeric vector with the custom time boundaries
to use in calculating relative characteristics for extreme events (i.e., to use
when exploring the role of adaptation in projections). For more
information on how reference temperatures are used, see the package
vignette for \code{futureheatwaves}. The required format for this vector
is c(start year, end year), with the restriction that bounds must be
contained within the time boundaries of one of the two experiment
subdirectories specified by the \code{dataDirectories} argument in
\code{\link{gen_hw_set}}. The default value is 2070 to 2079. If the
time bounds used differ from those used for projections, these reference
variables will be pulled from the ensemble member for each climate
model specified by \code{threshold_ensemble}.}

\item{numDays}{Integer greater than 0 giving the number of days to
use in the extreme event definition (e.g., \code{numDays = 2} would define a
heat wave as two or more days above the threshold temperature).}

\item{seasonal_months}{A numeric vector giving the months to use to
calculate the "mean.seasonal.var" column in the extreme event characteristics
output file. For example, if \code{seasonal_months} is set to \code{6:8},
daily temperatures from June through August each day during the reference
years would be used to calculate this mean seasonal value. The default
is \code{5:9} (May--September).}

\item{absolute_thresholds}{A numeric vector with four values giving the
absolute thresholds to use when calculating the "days.above.abs.thershold"
columns in the heatwave characteristic output files. These values must be
given in the units in which temperature is expressed in the input data
(typically Kelvin for climate model output data). The default values are the
values in Kelvin corresponding to 80, 85, 90, and 95 degrees Fahrenheit. If
this parameter is customized, it must include four values.}
}
\value{
Only stops and returns an error if any parameters are incorrect.
}
\description{
This function goes through all parameter inputs for \code{\link{gen_hw_set}}
and makes sure all parameter entries are in the appropriate format.
If any parameters are in an incorrect format, the function stops
and returns an error describing the problem.
}
\note{
This function does not check if the data is organized in the proper
   structure or if any data exists within the directory at all, so a
   call to \code{\link{gen_hw_set}} could still pass through this check and
   make it further through the function code with those mistakes.This
   function also does not check if the three ensemble final .csv data
   files exist, only if they have the .csv extension if they do exist.
}

