% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-immediateCondition.R
\name{readImmediateConditions}
\alias{readImmediateConditions}
\alias{saveImmediateCondition}
\title{Writes and Reads 'immediateCondition' RDS Files}
\usage{
readImmediateConditions(
  path = immediateConditionsPath(rootPath = rootPath),
  rootPath = tempdir(),
  pattern = "[.]rds$",
  include = getOption("future.relay.immediate", "immediateCondition"),
  signal = FALSE,
  remove = TRUE
)

saveImmediateCondition(
  cond,
  path = immediateConditionsPath(rootPath = rootPath),
  rootPath = tempdir()
)
}
\arguments{
\item{path}{(character string) The folder where the RDS files are.}

\item{pattern}{(character string) A regular expression selecting
the RDS files to be read.}

\item{include}{(character vector) The class or classes of the objects
to be kept.}

\item{signal}{(logical) If TRUE, the condition read are signaled.}

\item{remove}{(logical) If TRUE, the RDS files used are removed on exit.}

\item{cond}{A condition of class \code{immediateCondition}.}
}
\value{
\code{readImmediateConditions()} returns an unnamed \link[base:list]{base::list} of
named lists with elements \code{condition} and \code{signaled}, where
the \code{condition} elements hold \code{immediateCondition} objects.

\code{saveImmediateCondition()} returns, invisibly, the pathname of
the RDS written.
}
\description{
Writes and Reads 'immediateCondition' RDS Files
}
\keyword{internal}
