% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniprocessFuture-class.R
\name{UniprocessFuture-class}
\alias{UniprocessFuture-class}
\alias{UniprocessFuture}
\alias{SequentialFuture}
\alias{TransparentFuture}
\title{An uniprocess future is a future whose value will be resolved synchronously in the current process}
\usage{
UniprocessFuture(
  expr = NULL,
  substitute = TRUE,
  envir = parent.frame(),
  globals = TRUE,
  packages = NULL,
  lazy = FALSE,
  local = TRUE,
  ...
)

SequentialFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = TRUE,
  lazy = FALSE,
  globals = TRUE,
  local = TRUE,
  ...
)

TransparentFuture(
  expr = NULL,
  envir = parent.frame(),
  substitute = TRUE,
  lazy = FALSE,
  globals = TRUE,
  local = FALSE,
  ...
)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link[=future]{future()}}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{\dots}{Additional named elements passed to \code{\link[=Future]{Future()}}.}
}
\value{
An object of class \code{UniprocessFuture}.
}
\description{
An uniprocess future is a future whose value will be resolved synchronously in the current process
}
\seealso{
To evaluate an expression using "uniprocess future", see functions
\code{\link[=uniprocess]{uniprocess()}}.
}
\keyword{internal}
