% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/eager.R
\name{eager}
\alias{eager}
\title{Create an eager future whose value will be resolved immediately}
\usage{
eager(expr, envir = parent.frame(), substitute = TRUE, local = TRUE, ...)
}
\arguments{
\item{expr}{An R \link[base]{expression}.}

\item{envir}{The \link{environment} in which the evaluation
is done (or inherits from if \code{local} is TRUE).}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done in the calling environment.}

\item{...}{Not used.}
}
\value{
An \link{EagerFuture}.
}
\description{
An eager future is a future that uses eager evaluation, which means
that its \emph{value is computed and resolved immediately}, which is
how regular expressions are evaluated in R.  This type of future
exists mainly for the purpose of troubleshooting code that fails
with other types of futures.
}
\details{
The preferred way to create an eager future is not to call this function
directly, but to register it via \code{\link{plan}(eager)} such that it
becomes the default mechanism for all futures.  After this
\code{\link{future}()} and \code{\link{\%<=\%}} will create
\emph{eager futures}.
}
\examples{
## A global variable
a <- 0

## Create eager future (explicitly)
f <- eager({
  b <- 3
  c <- 2
  a * b * c
})

## Since 'a' is a global variable in _eager_ future 'f',
## it already has been resolved, and any changes to 'a'
## at this point will _not_ affect the value of 'f'.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)
}

