% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableCores.R
\name{availableCores}
\alias{availableCores}
\title{Get number of available cores on current machine}
\usage{
availableCores(methods = getOption("availableCoresMethods", c("Slurm", "PBS",
  "mc.cores", "system")))
}
\arguments{
\item{methods}{A character vector specifying how to infer the number
of available cores (and in what order).}
}
\value{
Return a positive integer equal or greater to one.
        If multicore processing is not supported, then one is returned.
}
\description{
Get number of available cores on current machine
}
\details{
The following methods for inferring the number of cores are supported:
\itemize{
 \item \code{"Slurm"} -
   Query Simple Linux Utility for Resource Management (Slurm)
   environment variable \code{SLURM_CPUS_PER_TASK}.
   This may or may not be set.  It can be set when submitting a job,
   e.g. `sbatch --cpus-per-task=2 hello.sh` or by adding
   `#SBATCH --cpus-per-task=2` to the `hello.sh` script.
 \item \code{"PBS"} -
   Query Torque/PBS environment variable \code{PBS_NUM_PPN}.
   Depending on PBS system configuration, this \emph{resource} parameter
   may or may not default to one.  It can be specified when submitting
   a job as in, for instance, \code{qsub -l nodes=4:ppn=2}, which
   requests four nodes each with two cores.
 \item \code{"mc.cores"} -
   Query option \code{mc.cores}, cf. \code{\link[parallel]{mclapply}()}.
 \item \code{"system"} -
   Query \code{\link[parallel]{detectCores}()}.
}
}
\seealso{
\code{\link[parallel]{detectCores}()}
}
\keyword{internal}

