% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ensemble.R
\name{rmatrix}
\alias{eigenvalues}
\alias{hermitian}
\alias{max_eigen}
\alias{rmatrix}
\alias{symmetric}
\title{Generation of random matrices}
\arguments{
\item{model}{The matrix model to use, which includes the size of
the matrix. The model argument must be of type RandomMatrixModel. 
Numerous sub-types (e.g. WignerModel, WishartModel) are
supported generating the appropriate type of random matrix.}
}
\description{
Generate various types of random matrices
}
\section{Usage}{

rmatrix(model) %::% WignerModel : matrix

rmatrix(model) %::% WishartModel : matrix

rmatrix(model) %::% JacobiModel : matrix

rmatrix(model)
}

\section{Details}{

Used to generate a random matrix from various families. The idea
is to specify a model, which is then used to generate random realizations
and also to compute other properties of the matrix.
}
\examples{
model <- WignerModel(10)
m <- rmatrix(model)

\dontrun{
e <- Ensemble(20, model)
hist(max_eigen(e), freq=FALSE)
}
}
\seealso{
\code{\link{dmatrix}}
}

