% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_dev_history.R
\name{add_dev_history}
\alias{add_dev_history}
\title{Add dev_history.Rmd file that drives package development}
\usage{
add_dev_history(
  pkg = ".",
  overwrite = FALSE,
  open = TRUE,
  dev_dir = "dev",
  name = c("full", "minimal", "additional", "teaching")
)
}
\arguments{
\item{pkg}{Path where to save file}

\item{overwrite}{Whether to overwrite existing dev_history.Rmd file}

\item{open}{Logical. Whether to open file after creation}

\item{dev_dir}{Name of directory for development Rmarkdown files. Default to "dev".}

\item{name}{Name of the template file. See details.}
}
\value{
Create a dev_history.Rmd file and return its path
}
\description{
Add dev_history.Rmd file that drives package development
}
\details{
Choose \code{name} among the different templates available:
\itemize{
\item "full": the full template with a reproducible package to inflate directly. Default.
\item "minimal": Minimal template to start a new package when you already know {fusen}.
\item "additional": Template for an additional vignette, thus additional functions.
\item "teaching": Template with a reproducible package, simpler than "full", but everything to
teach the minimal structure of a package.
}
}
\examples{
# Create a new project
tmpdir <- tempdir()
dummypackage <- file.path(tmpdir, "dummypackage")
dir.create(dummypackage)

# Add
add_dev_history(pkg = dummypackage)

# Delete dummy package
unlink(dummypackage, recursive = TRUE)
}
