% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simFA.R
\name{simFA}
\alias{simFA}
\title{Generate Factor Analysis Models and Data Sets for Simulation Studies}
\usage{
simFA(
  Model = list(),
  Loadings = list(),
  CrossLoadings = list(),
  Phi = list(),
  ModelError = list(),
  Bifactor = list(),
  MonteCarlo = list(),
  FactorScores = list(),
  Missing = list(),
  Control = list(),
  Seed = NULL
)
}
\arguments{
\item{Model}{(list) 
\itemize{ 
        \item \code{NFac} (scalar) Number of common or
                      group factors; defaults to \code{NFac = 3}.  
        \item \code{NItemPerFac}
             \itemize{ 
                \item (scalar) All factors have the same number
                   of primary loadings.  
                 \item (vector) A vector of length \code{NFac} specifying the
                       number of primary loadings for each factor; defaults 
                       to \code{NItemPerFac = 3}.  } 
                \item \code{Model} (character) \code{"orthogonal"} or
                      \code{"oblique"}; defaults to 
                      \code{Model = "orthogonal"}.  }}

\item{Loadings}{(list) 
     \itemize{ 
             \item \code{FacPattern} (\code{NULL} or matrix).        
                 \itemize{ 
                          \item \code{FacPattern = M} where \code{M} is 
                                a user-defined factor pattern matrix.  
                          \item \code{FacPattern = NULL};
                          \code{simFA} will generate a factor pattern based on 
                           the arguments specified  under other keywords 
                          (e.g., \code{Model}, \code{CrossLoadings}, etc.);
                          defaults to \code{FacPattern = NULL}.  } 
              \item \code{FacLoadDist}  (character) Specifies the 
                  sampling distribution for the common factor
                  loadings. Possible values are \code{"runif"}, 
                  \code{"rnorm"}, \code{"sequential"}, and \code{"fixed"}; 
                  defaults to \code{FacLoadDist = "runif"}.  
              \item \code{FacLoadRange} (vector of length \code{NFac}, 
                      2, or 1); defaults to \code{FacLoadRange = c(.3, .7)}.  
                      \itemize{ 
                        \item If \code{FacLoadDist = "runif"} the vector 
                        defines the bounds of the uniform distribution; 
                        \item If \code{FacLoadDist = "rnorm"} the vector defines the
                         mean and standard deviation of the normal distribution from 
                         which loadings are sampled.  
                       \item If \code{FacLoadDist = "sequential"} the vector
                        specifies the lower and upper bound of the loadings sequence.  
                       \item If \code{FacLoadDist = "fixed"} and 
                                \code{FacLoadRange} is a vector of length 1
                                then all common loadings will equal the constant 
                                specified in \code{FacLoadRange}. 
                                If \code{FacLoadDist = "fixed"} and 
                                \code{FacLoadRange} is a vector of length 
                                \code{NFac} then each factor will have fixed loadings
                                as specified by the associated element in 
                                \code{FacLoadRange}.  }

               \item \code{h2} (vector) An optional vector of communalities 
                    used to constrain the population communalities to user-defined 
                    values; defaults to \code{h2 = NULL}.  }}

\item{CrossLoadings}{(list) 
\itemize{ 
    \item \code{ProbCrossLoad} (scalar) A value in the (0,1) interval 
        that determines the probability that a cross loading will be 
        present in elements of the loadings matrix that do not have
        salient (primary) factor loadings.  
        If set to \code{ProbCrossLoad = 1}, a
        single cross loading will be added to each factor;  defaults to
        \code{ProbCrossLoad = 0}.
    \item \code{CrossLoadRange} (vector of length 2) Controls 
        size of the crossloadings; defaults to 
        \code{CrossLoadRange= c(.20, .25)}.  
    \item \code{CrossLoadPositions} (matrix) Specifies the row and column 
        positions of (optional) cross-loadings; defaults to 
        \code{CrossLoadPositions = NULL}.
    \item \code{CrossLoadValues} (vector) If 
          \code{CrossLoadPositions} is specified then 
          \code{CrossLoadValues} is a vector of user-supplied
           cross-loadings; defaults to 
           \code{CrossLoadValues = NULL}.  
    \item \code{CrudFactor} (scalar) Controls the size of tertiary 
       factor loadings. If \code{CrudFactor != 0} then elements of 
       the loadings matrix with neither primary nor secondary 
       (i.e., cross) loadings will be sampled from a
       [-(CrudFactor), (CrudFactor)] uniform distribution; 
       defaults to \code{CrudFactor = 0}.  }}

\item{Phi}{(list) 
\itemize{
    \item \code{MaxAbsPhi} (scalar) Upper (absolute) bound on factor
        correlations; defaults to \code{MaxAbsPhi = .5}.  
    \item \code{EigenValPower} (scalar) Controls the skewness of the 
       eigenvalues of Phi. Larger values of \code{EigenValPower} result 
       in a Phi spectrum that is more right-skewed (and
       thus closer to a unidimensional model); 
       defaults to \code{EigenValPower = 2}.  
    \item \code{PhiType} (character); defaults to 
       \code{PhiType = "free"}.
       \itemize{ 
          \item If \code{PhiType = "free"} factor correlations 
             will be randomly generated under the constraints of 
             \code{MaxAbsPhi} and \code{EigenValPower}.  
           \item If \code{PhiType = "fixed"} all factor
             correlations will equal the value specified in 
             \code{MaxAbsPhi}. A fatal error will be produced if 
             \code{Phi} is not positive semidefinite.  
           \item If \code{PhiType = "user"} the factor correlations are 
              defined by the matrix specified in \code{UserPhi} (see below).} 
      \item \code{UserPhi} (matrix) A positive semidefinite (PSD) matrix 
        of user-defined factor correlations;defaults to \code{UserPhi = NULL}.}}

\item{ModelError}{(list) 
\itemize{ 
   \item \code{ModelError} (logical) If
         \code{ModelError = TRUE} model error will be introduced into 
         the factor pattern via the method described by Tucker, Koopman, 
         and Linn (TKL, 1969); defaults to \code{ModelError = FALSE}.  
   \item \code{NMinorFac} (scalar) Number of minor factors in the TKL model; 
       defaults to \code{NMinorFac = 150}.  
   \item \code{ModelErrorType} (character) If \code{ModelErrorType =
       "U"} then \code{ModelErrorVar} is the proportion of uniqueness 
       variance that is due to model error.  
       If \code{ModelErrorType = "V"} then
       \code{ModelErrorVar} is the proportion of total variance that 
       is due to model error; defaults to \code{ModelErrorType = "U"}.  
   \item \code{ModelErrorVar} (scalar [0,1]) The proportion of 
       uniqueness (U) or total (V) variance that is due to model error; 
       defaults to \code{ModelErrorVar = .10}.  
   \item \code{epsTKL} (scalar [0,1]) Controls the size of the factor 
      loadings in successive minor factors; defaults to \code{epsTKL = .20}.  
   \item \code{RSpecific} (matrix) Optional correlation
       matrix for specific factors; defaults to \code{RSpecific = NULL}. }}

\item{Bifactor}{(list) 
\itemize{ 
   \item Bifactor (logical) If \code{Bifactor = TRUE} parameters for 
       the bifactor model will be generated; defaults to
       \code{Bifactor = FALSE}.  
   \item Hierarchical (logical) If \code{Hierarchical
        = TRUE} then a hierarchical Schmid Leiman (1957) bifactor model 
        will be generated; defaults to \code{Hierarchical = FALSE}.  
   \item 
      \code{F1FactorDist} (character) Specifies the sampling distribution 
         for the general factor loadings.  Possible values are 
      \code{"runif"}, 
      \code{"rnorm"}, 
      \code{"sequential"}, and 
      \code{"fixed"}; defaults to
      \code{F1FactorDist = "sequential"}.  
   \item \code{F1FactorRange} (vector of length 1 or 2) Controls the 
      sizes of the general factor loadings in
      nonhierarchical bifactor models; defaults to 
      \code{F1FactorRange = c(.4, .7)}.  
        \itemize{ 
            \item If \code{F1FactorDist = "runif"}, the vector of
                length 2 defines the bounds of the uniform distribution, 
                c(lower, upper);
             \item If \code{F1FactorDist = "rnorm"}, the vector defines 
                the mean and standard deviation of the normal distribution 
                from which loadings are sampled, c(MN, SD).  
             \item If \code{F1FactorDist = "sequential"}, the vector
                specifies the lower and upper bound of the loadings 
                sequence, c(lower, upper).  }
   }}

\item{MonteCarlo}{(list) 
\itemize{ 
    \item \code{NSamples} (integer) Defines
       number of Monte Carlo Samples; defaults to \code{NSamples = 0}.  
    \item \code{SampleSize} (integer) Sample size for each Monte 
       Carlo sample; defaults to \code{SampleSize = 250}.  
    \item \code{Raw} (logical) If \code{Raw = TRUE}, simulated data sets 
       will contain raw data.  If \code{Raw = FALSE}, simulated data sets 
       will contain correlation matrices; defaults to
       \code{Raw = FALSE}.  
    \item \code{Thresholds} (list) List elements contain
        thresholds for each item. Thresholds are required when generating 
        Likert variables.  }}

\item{FactorScores}{(list) 
\itemize{ 
    \item \code{FS} (logical) If \code{FS = TRUE} (true) factor scores 
       will be simulated; defaults to \code{FS = FALSE}.
     \item \code{CFSeed} (integer) Optional starting seed for the common 
        factor scores; defaults to \code{CFSeed = NULL} in which case a 
        random seed is used.  
     \item \code{SFSeed} (integer) Optional starting seed for the 
        specific factor scores; defaults to \code{SFSeed = NULL} in 
        which case a random seed is used.  
     \item \code{EFSeed} (integer) Optional starting seed for the error
         factor scores; defaults to 
           \code{EFSeed = NULL} in which case a 
             random seed is used. Note that 
           \code{CFSeed}, 
           \code{SFSeed}, and 
           \code{EFSeed} must be
           different numbers (a fatal error is produced when two or more 
           seeds are specified as equal).  
      \item \code{VarRel} (vector) A vector of manifest
          variable reliabilities.  The specific factor variance for 
          variable \emph{i} will equal \eqn{VarRel[i] - h^2[i]} 
          (the manifest variable reliability minus
           its commonality). By default, \eqn{VarRel = h^2} (resulting 
           in uniformly zero specific factor variances).  
      \item \code{Population} (logical) If \code{Population = TRUE}, 
         factor scores will fit the correlational
         constraints of the factor model exactly (e.g., the common factors 
         will be orthogonal to the unique factors); defaults to 
         \code{Population = FALSE}.
       \item \code{NFacScores} (scalar) Sample size for the factor scores; 
           defaults to \code{NFacScores = 250}.  
       \item \code{Thresholds} (list) A list of quantiles used to polychotomize 
          the observed data that will be generated from the factor scores.  }}

\item{Missing}{(list) 
\itemize{ 
   \item Missing (logical) If \code{Missing = TRUE} all data sets will 
      contain missing values; defaults to \code{Missing = FALSE}.  
   \item \code{Mechanism} (character) Specifies the missing data
       mechanism.  Currently, the program only supports missing completely at
       random (MCAR): \code{Missing = "MCAR"}.  
   \item \code{MSProb} (scalar or vector of length \code{NVar}) Specifies 
      the probability of missingness for each variable; defaults to 
      \code{MSprob = 0}.  }}

\item{Control}{(list) 
\itemize{ 
   \item \code{Maxh2} (scalar) Rows of the
       loadings matrix will be rescaled to have a maximum communality of
       \code{Maxh2}; defaults to \code{Maxh2 = .98}.  
       \code{itemReflect} (logical) If \code{Reflect = TRUE} loadings on 
       the common factors will be randomly reflected; defaults to 
       \code{Reflect = FALSE}.  }}

\item{Seed}{(integer) Starting seed for the random number generator;
defaults to \code{Seed = NULL}. When no seed is specified by the 
user, the program will generate a random seed.}
}
\value{
\itemize{ 
         \item \code{loadings} A common factor or bifactor loadings
             matrix.  
         \item \code{Phi} A factor correlation matrix.  
         \item \code{urloadings} The unrotated loadings matrix.  
         \item \code{h2} A vector of item commonalities.  
         \item\code{h2PopME} A vector item commonalities that may include
                model approximation error.
         \item \code{Rpop} The model-implied population correlation matrix.  
         \item \code{RpopME} The model-implied population
                correlation matrix with model error.  
         \item \code{CovMatrices} A list
                containing: 
                \itemize{ 
                   \item \code{CovMajor} The model implied covariances
                      from the major factors.  
                   \item \code{CovMinor} The model implied covariances
                      from the minor factors.  
                   \item \code{CovUnique} The model implied variances
                      from the uniqueness factors.  } 
               \code{Bifactor} A list containing: 
                 \itemize{
                     \item \code{loadingsHier} Factor loadings of the 1st 
                        order solution of a hierarchical bifactor model.  
                     \item \code{PhiHier} Factor correlations of
                        the 1st order solution of a hierarchical bifactor model.  } 
                 \item \code{Scores} A list containing: 
                  \itemize{ 
                      \item\code{FactorScores} Factor scores for the common 
                           and uniqueness factors.  
                      \item \code{FacInd} Factor
                          indeterminacy indices for the error free population model.  
                      \item \code{FacIndME} Factor score indeterminacy indices for 
                         the population model with model error.  
                      \item \code{ObservedScores} A matrix of model implied
                            \code{ObservedScores}. If 
                            \code{Thresholds} were supplied under Keyword
                            \code{FactorScores}, 
                            \code{ObservedScores} will be transformed into Likert
                                 scores.  } 
                \item\code{Monte} A list containing output from the Monte Carlo
                     simulations if generated.  
                \item\code{IRT}Factor loadings expressed in the
                    normal ogive IRT metric. If \code{Thresholds} were given 
                    then IRT difficulty values will also be returned.  
                \item\code{Seed}The initial seed for the
                     random number generator.  
                \item\code{call}A copy of the function call.
                \item\code{cn}A list of all active and nonactive function arguments.}
}
\description{
A function to simulate factor loadings matrices and Monte Carlo data sets
for common factor models and bifactor models.
}
\details{
\code{simFA} was specifically designed to simplify the process of running
Monte Carlo studies of factor analysis models. Thus, \code{simFA} can save
all relevant output for a user-specified model. Saved output can be accessed
by calling one or more of the following object names.
}
\examples{

#  Ex 1. Three Factor Simple Structure Model with Crossloadings and 
#  Ideal Nonsalient Loadings
   out <-  simFA(Seed = 1)
   print( round( out$loadings, 2 ) )

# Ex 2. Non Hierarchical bifactor model 3 group factors
# with constant loadings on the general factor
   out <- simFA(Bifactor = list(Bifactor = TRUE,
                                Hierarchical = FALSE,
                                F1FactorRange = c(.4, .4),
                                F1FactorDist = "runif"),
                Seed = 1)
   print( round( out$loadings, 2 ) ) 
   
}
\references{
Schmid, J. and Leiman, J. M.  (1957).  The development of hierarchical
factor solutions.  Psychometrika, 22(1), 53--61.

Tucker, L. R., Koopman, R. F., and Linn, R. L.  (1969).  Evaluation of
factor analytic research procedures by means of simulated correlation
matrices.  Psychometrika, 34(4), 421--459.
}
\author{
Niels G. Waller
}
\keyword{stats}
