#' Length, width, and height measurements for Thurstone's 20 boxes
#'
#' Length, width, and height measurements for Thurstone's 20 hypothetical boxes
#'
#' @docType data
#' 
#' @usage data(Box20)
#' 
#' @format A data set of measurements for Thurstone's 20 hypothetical boxes. 
#' The data set includes three variables:
#' \itemize{
#'    \item \strong{x} Box length
#'    \item \strong{y} Box width
#'    \item \strong{z} Box height
#'  }  
#' 
#'
#' @keywords datasets
#
#' @examples 
#' data(Box20)
#' 
#' hist(Box20$x,
#'      main = "Histogram of Box Lengths",
#'      xlab = "Length",
#'      col = "blue")
#' 
#'
"Box20"

