% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SchmidLeiman.R
\name{SchmidLeiman}
\alias{SchmidLeiman}
\title{Schmid-Leiman Orthogonalization to a (Rank-Deficient) Bifactor Structure}
\usage{
SchmidLeiman(R, numFactors, facMethod = "fals", rotate = "geominQ",
  numberStarts = 10, rescaleH2 = 0.98, digits = NULL,
  rotateControl = NULL, faControl = NULL)
}
\arguments{
\item{R}{(Matrix) A correlation matrix.}

\item{numFactors}{(Vector) The number of latent factors at each level of analysis. For example, c(3, 1) estimates three latent factors in the first-order common factor model and one latent factor in the second-order common factor model (i.e., 3 group factors and 1 general factor). This function can orthogonalize up to (and including) a three-order factor solution.}

\item{facMethod}{(Character) The method used for factor extraction (see \code{\link{faX}} for more details). The supported options are "fals" for unweighted least squares, "faml" for maximum likelihood, and "fapa" for iterated principal axis factoring. The default method is "fals".
\itemize{
  \item \strong{"fals"}: Factors are extracted using the unweighted least squares estimation procedure using the \code{\link[fungible]{fals}} function.
  \item \strong{"faml"}: Factors are extracted using the maximum likelihood estimation procedure using the \code{\link[stats]{factanal}} function.
  \item \strong{"fapa"}: Factors are extracted using the iterated principal axis factoring estimation procedure using the \code{\link{fapa}} function.
}}

\item{rotate}{(Character) Designate which rotation algorithm to apply. See the \code{\link{rotate}} function for more details about possible rotations. A geomin rotation is the default.}

\item{numberStarts}{(Numeric) Designate the number of random starting configurations for each factor rotation.}

\item{rescaleH2}{(Numeric) If a Heywood case is detected at any level of the higher-order factor analyses, rescale the communality value to continue with the matrix algebra. When a Heywood case occurs, the uniquenesses (i.e., specific-factor variances) will be negative and the SL orthogonalization of the group factors is no longer correct.}

\item{digits}{(Numberic) Number of digits to round factor loadings in the resulting bifactor solution.}

\item{rotateControl}{(List) A list of control values to pass to the factor rotations in the \code{\link{rotate}} function.
\itemize{
  \item \strong{gamma}: (Numberic) This is a tuning parameter (between 0 and 1, inclusive) for an oblimin rotation.  See the GPArotation library's oblimin documentation for more details.
  \item \strong{delta}: (Numberic) This is a tuning parameter for the geomin rotation. It adds a small number (default = .01) to factor loadings before computing the geometric means in the discrepancy function.
  \item \strong{kappa}: (Numeric) The main parameterization of the Crawford-Ferguson family of factor rotations. Specific values correspond to certain rotations. For instance (adapted from GPArotation's help page), 0=Quartimax, 1/p=varimax, m/(2*p)=Equamax, (m-1)/(p+m-2)=Parsimax, 1=Factor parsimony. Note that 'p' is the number of factor indicators and 'm' is the number of common factors. The default value is 0 (Quartimax).
  \item \strong{k}: (Numeric) A specific parameter of the simplimax rotation. The default value is nrow(lambda).
  \item \strong{epsilon}: (Numeric) The rotational convergence criterion to use. The default value is 1e-5.
  \item \strong{power}: (Numeric) Raise factor loadings the the n-th power in the promax rotation. The default value is 4.
  \item \strong{norm}: (Logical) A logical value indicating whether to compute Kaiser normalization. Default is FALSE
  \item \strong{maxITR}: (Numeric) The maximum number of allowed iterations for convergence before stopping the rotation. The default value is 15,000 iterations.
}}

\item{faControl}{(List) A list of optional parameters passed to the factor extraction (\code{\link{faX}}) function.
\itemize{
  \item \strong{treatHeywood}: (Logical) In fals, if treatHeywood is true, a penalized least squares function is used to bound the communality estimates below 1.0. The default is TRUE.
  \item \strong{nStart}: (Numeric) In faml, determine the number of starting values to try. The default is 10 start values.
  \item \strong{maxCommunality}: (Numeric) In faml, set the maximum communality value for the estimated solution. The default maximum is .995.
  \item \strong{epsilon}: (Numeric) In fapa, the numeric threshold designating when the algorithm has converged. The default value is 1e-4.
  \item \strong{communality}: (Character) In fapa, the routine requires an initial communality estimate. Select how communalities are initially estimated. The default is squared multiple correlation ("SMC").
  \itemize{
    \item \strong{"SMC"}: Initial communalities are estimated by taking the squared multiple correlations of each indicator after regressing the indicator on the remaining variables. The following equation is employed to find the squared multiple correlation: \eqn{1 - 1 / diag(R^-1)}.
    \item \strong{"maxRsqr"}: Initial communalities equal the largest squared correlation in each column of the correlation matrix.
    \item \strong{"unity"}: Initial communalities equal 1.0 for all variables.
  }
  \item \strong{maxITR}: (Numeric) In fapa, the maximum number of iterations to reach convergence. The default is 15,000
}}
}
\value{
\itemize{
  \item \strong{L1}: (Matrix) The first-order (oblique) factor pattern matrix.
  \item \strong{L2}: (Matrix) The second-order (oblique) factor pattern matrix.
  \item \strong{L3}: (Matrix, NULL) The third-order (oblique) factor pattern matrix (if applicable).
  \item \strong{Phi1}: (Matrix) The first-order factor correlation matrix.
  \item \strong{Phi2}: (Matrix) The second-order factor correlation matrix.
  \item \strong{Phi3}: (Matrix, NULL) The third-order factor pattern matrix (if applicable).
  \item \strong{Usq1}: (Matrix) The first-order factor uniquenesses (variances).
  \item \strong{Usq2}: (Matrix) The second-order factor uniquenesses (variances).
  \item \strong{Usq3}: (Matrix, NULL) The third-order factor uniquenesses (variances) (if applicable).
  \item \strong{B}: (Matrix) The resulting Schmid-Leiman transformation.
  \item \strong{rotateControl}: (List) A list of the control parameters passed to the \code{\link{rotate}} function.
  \item \strong{faControl}: (List) A list of optional parameters passed to the factor extraction (\code{\link{faX}}) function.
}
}
\description{
The Schmid-Leiman (SL) procedure orthogonalizes a higher-order factor structure into a rank-deficient bifactor structure. The Schmid-Leiman method is a generalization of Thomson's orthogonalization routine.
}
\examples{
## Dataset used in Schmid & Leiman (1957) rounded to 2 decimal places
SLdata <-
  matrix(c(1.0, .72, .31, .27, .10, .05, .13, .04, .29, .16, .06, .08,
           .72, 1.0, .35, .30, .11, .06, .15, .04, .33, .18, .07, .08,
           .31, .35, 1.0, .42, .08, .04, .10, .03, .22, .12, .05, .06,
           .27, .30, .42, 1.0, .06, .03, .08, .02, .19, .11, .04, .05,
           .10, .11, .08, .06, 1.0, .32, .13, .04, .11, .06, .02, .03,
           .05, .06, .04, .03, .32, 1.0, .07, .02, .05, .03, .01, .01,
           .13, .15, .10, .08, .13, .07, 1.0, .14, .14, .08, .03, .04,
           .04, .04, .03, .02, .04, .02, .14, 1.0, .04, .02, .01, .01,
           .29, .33, .22, .19, .11, .05, .14, .04, 1.0, .45, .15, .17,
           .16, .18, .12, .11, .06, .03, .08, .02, .45, 1.0, .08, .09,
           .06, .07, .05, .04, .02, .01, .03, .01, .15, .08, 1.0, .42,
           .08, .08, .06, .05, .03, .01, .04, .01, .17, .09, .42, 1.0),
         nrow = 12, ncol = 12, byrow = TRUE)

Out1 <- SchmidLeiman(R          = SLdata,
                     numFactors = c(6, 3, 1),
                     digits     = 2)$B

## An orthogonalization of a two-order structure
bifactor <- matrix(c(.16, .37, .00, .00,
                     .18, .41, .00, .00,
                     .21, .48, .00, .00,
                     .36, .00, .55, .00,
                     .21, .00, .32, .00,
                     .36, .00, .55, .00,
                     .47, .00, .00, .48,
                     .40, .00, .00, .40,
                     .39, .00, .00, .39),
                   nrow = 9, ncol = 3, byrow = TRUE)

## Model-implied correlation (covariance) matrix
R <- bifactor \%*\% t(bifactor)

## Unit diagonal elements
diag(R) <- 1

Out1 <- SchmidLeiman(R          = R,
                     numFactors = c(3, 1),
                     digits     = 2)$B

}
\references{
Abad, F. J., Garcia-Garzon, E., Garrido, L. E., & Barrada, J. R. (2017). Iteration of partially specified target matrices: application to the bi-factor case. \emph{Multivariate Behavioral Research, 52}(4), 416-429.

Giordano, C. & Waller, N. G. (under review). Recovering bifactor models: A comparison of seven methods.

Schmid, J., & Leiman, J. M. (1957). The development of hierarchical factor solutions. \emph{Psychometrika, 22}(1), 53-61.
}
\author{
\itemize{
  \item Casey Giordano (Giord023@umn.edu)
  \item Niels G. Waller (nwaller@umn.edu)
}
}
