\name{rellipsoid}
\alias{rellipsoid}
\title{Generate Uniformly Spaced OLS Regression Coefficients that Yield a User-Supplied R-Squared Value}
\description{
Given predictor matrix R, generate OLS regression coefficients that yield a user-supplied R-Squared value. These regression coefficient vectors will be uniformly spaced on the surface of a (hyper) ellipsoid. 
}
\usage{
rellipsoid(R, Rsq, Npoints)
}
\arguments{
 \item{R}{A p x p predictor correlation matrix.}
 \item{Rsq}{A user-supplied R-squared value.}
 \item{Npoints}{Desired number of generated regression vectors.}
}
\value{ 
 \item{b}{A p x Npoints matrix of regression coefficients}
}
\references{
Waller, N. G. and Jones, J. A. (2011). Investigating the performance of alternate regression weights by studying all possible criteria in regression models with a fixed set of predictors. \emph{Psychometrika, 76}, 410-439.
}
\author{Niels Waller and Jeff Jones.}
\examples{
## generate uniformly distributed regression vectors
## on the surface of a 14-dimensional ellipsoid 
N <- 10000
Rsq <- .21

# Correlations from page 224 WAIS-III manual 
# The Psychological Corporation (1997).
wais3 <- matrix(
 c(1, .76, .58, .43, .75, .75, .42, .54, .41, .57, .64, .54, .50, .53,
 .76,   1, .57, .36, .69, .71, .45, .52, .36, .63, .68, .51, .47, .54,
 .58, .57,   1, .45, .65, .60, .47, .48, .43, .59, .60, .49, .56, .47,
 .43, .36, .45,   1, .37, .40, .60, .30, .32, .34, .35, .28, .35, .29,
 .75, .69, .65, .37,   1, .70, .44, .54, .34, .59, .62, .54, .45, .50,
 .75, .71, .60, .40, .70,   1, .42, .51, .44, .53, .60, .50, .52, .44,
 .42, .45, .47, .60, .44, .42,   1, .46, .49, .47, .43, .27, .50, .42,
 .54, .52, .48, .30, .54, .51, .46,   1, .45, .50, .58, .55, .53, .56,
 .41, .36, .43, .32, .34, .44, .49, .45,   1, .47, .49, .41, .70, .38,
 .57, .63, .59, .34, .59, .53, .47, .50, .47,   1, .63, .62, .58, .66,
 .64, .68, .60, .35, .62, .60, .43, .58, .49, .63,   1, .59, .50, .59,
 .54, .51, .49, .28, .54, .50, .27, .55, .41, .62, .59,   1, .48, .53,
 .50, .47, .56, .35, .45, .52, .50, .53, .70, .58, .50, .48,   1, .51,
 .53, .54, .47, .29, .50, .44, .42, .56, .38, .66, .59, .53, .51,   1),
 nrow = 14, ncol = 14)

R <- wais3[1:6,1:6]             
b <- rellipsoid(R, Rsq, Npoints = N)
b <- b$b
# 
plot(b[1,],b[2,])
} 	
\keyword{datagen}% at least one, from doc/KEYWORDS
