% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{AICc}
\alias{AICc}
\title{AICc of two numeric vectors}
\usage{
AICc(x, y, nbK)
}
\arguments{
\item{x, y}{two numeric vectors of same length.}

\item{nbK}{an integer. \code{nbK} is the number of used parameters.
\code{nbK > 1} : returns \code{NA} if not.}
}
\value{
Return the Akaike Information Criterion ((\code{AICc})),
corrected for the second order bias.
}
\description{
Take two numeric vectors and return the Akaike Information
 Criterion (\code{AICc}) corrected for the second order.
 \code{AICc} is computed from the Residuals Sum of Square
 (\code{\link{rss}}) and
 the number of used parameters.
}
\details{
The correction for the second order bias
improves the Akaike Information Criterion
when (\code{length(x)}) is small.
}
\note{
The correction for the second order bias
improves the Akaike Information Criterion
when \code{length(x)} is small.
}
\keyword{internal}
