% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validating_jack.R
\name{validate_gmean_byelt_jack_xpr}
\alias{validate_gmean_byelt_jack_xpr}
\title{Predicting the performances
 by elements occurring within assembly motif
 using jackknife method
 over several experiments}
\usage{
validate_gmean_byelt_jack_xpr(fobs, assMotif, mOccur, jack, xpr)
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{assMotif}{a vector of labels of \code{length(fobs)}.
The vector \code{assMotif} contains the assembly motifs of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{jack}{an integer vector of length \code{2}.
The vector specifies the parameters for jackknife method.
The first integer \code{jack[1]} specifies the size of subset,
the second integer \code{jack[2]} specifies the number of subsets.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{} is generated
by the function \code{stats::setNames}.}
}
\value{
Return a vector of \code{length(fobs)}.
Its values are computed as the geometric mean of performances
of assemblages that share a same assembly motif,
by excluding a subset of assemblages
containing the assemblage to predict.
}
\description{
Take a vector \code{fobs} of assembly performances
and return a vector of performances predicted
as the geometric mean of performances of other assemblages
that share the same assembly motif.
Assembly motifs are described in the vector \code{assMotif}.
Experiments are specified in the vector \code{xpr}.
}
\details{
Predicted performances are computed
using geometric mean (\code{opt.mean = "gmean"})
of performances of assemblages
  that share a same assembly motif (\code{opt.model = "bymot"}).

The assemblages belonging to a same assembly motif are divided
 into \code{jack[2]} subsets of \code{jack[1]} assemblages.
  Prediction is computed by excluding \code{jack[1]} assemblages,
  including the assemblage to predict.
   If the total number of assemblages belonging
  to the assembly motif is lower than \code{jack[1]*jack[2]},
   prediction is computed by Leave-One-Out (LOO).
}
\seealso{
\code{\link{validate_amean_bymot_jack_xpr}},
         \code{\link{validate_amean_byelt_jack_xpr}},
         \code{\link{validate_gmean_bymot_jack_xpr}}
}
\keyword{internal}
