% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{rss_clustering}
\alias{rss_clustering}
\title{Residual Sum of Squares of a given clustering model}
\usage{
rss_clustering(fobs, affectElt, mOccur, xpr, opt.mean, opt.model )
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{affectElt}{a vector of integers
of \code{length(affectElt) == dim(mOccur)[1]},
that is the number of components.
The vector contains the labels of different functional clusters
to which each component belongs.
Each functional cluster is labelled as an integer, and
each component must be identified by its name in \code{names(affectElt)}.
The number of functional clusters defined in \code{affectElt}
determines an \emph{a priori} level of component clustering
(\code{level <- length(unique(affectElt))}).\cr

If \code{affectElt = NULL} (value by default),
the option \code{opt.method} must be filled out.
A tree is built,
from a unique trunk to as many leaves as components
by using the specified method. \cr

If \code{affectElt} is specified,
the option \code{opt.method} does not need to be filled out.
\code{affectElt} determines an \emph{a priori}
level of component clustering,
and a tree is built:
\emph{(i)} by using \code{opt.method =  "divisive"}
from the \emph{a priori} defined level in tree towards
as many leaves as components;
\emph{(ii)} by using \code{opt.method =  "agglomerative"}
from the \emph{a priori} defined level in tree towards the tree trunk
(all components are together withi a trivial singleton).}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{xpr}{a vector of numerics of \code{length(fobs)}.
The vector \code{xpr} contains the weight of each experiment,
and the labels (in \code{names(xpr)}) of different experiments.
The weigth of each experiment is used
in the computation of the Residual Sum of Squares
in the function \code{rss_clustering}.
The used formula is \code{rss}
if each experiment has the same weight.
The used formula is \code{wrss}
(barycenter of RSS for each experiment)
if each experiment has different weights.
All assemblages that belong to a given experiment
should then have a same weigth.
Each experiment is identified by its names (\code{names(xpr)})
and the RSS of each experiment is weighted by values of \code{xpr}.
The vector \code{xpr} is generated
by the function \code{stats::setNames}.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switchs to arithmetic formula if \code{opt.mean = "amean"}.
Switchs to geometric formula if \code{opt.mean = "gmean"}. \cr

Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
or geometric mean (\code{opt.mean = "gmean"})
according to \code{opt.model}.}

\item{opt.model}{a character equals to \code{"bymot"} or \code{"byelt"}.
Switchs to simple mean by assembly motif if \code{opt.model = "bymot"}.
Switchs to linear model with assembly motif if \code{opt.model = "byelt"}.
  \cr

If \code{opt.model = "bymot"},
modelled performances are means
of performances of assemblages
that share a same assembly motif
by including all assemblages that belong to a same assembly motif. \cr

If \code{opt.model = "byelt"},
modelled performances are the average
of mean performances of assemblages
that share a same assembly motif
and that contain the same components
as the assemblage to predict.
This procedure corresponds to a linear model within each assembly motif
based on the component occurrence in each assemblage.
If no assemblage contains component belonging to assemblage to predict,
performance is the mean performance of all assemblages
as in \code{opt.model = "bymot"}.}
}
\value{
Return the Residual Sum of Squares
of a given clustering model.
Its value is computed according to \code{opt.mean} and \code{opt.model}.
}
\description{
Take performance, occurrence matrix
and a clustering model,
then compute the corresponding Residual Sum of Squares.
}
\details{
None.
}
\keyword{internal}
