% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fexport.R
\name{fclust_read}
\alias{fclust_read}
\title{Read a functional clustering for one or several performances}
\usage{
fclust_read(filename = "")
}
\arguments{
\item{filename}{a string, used as radical for the 6 file names.}
}
\value{
The result of the functional clustering
  recorded in the files \code{"filename.*.csv"}.
}
\description{
Read the files resulting from a functional clustering
  and saved in text format in 6 different files
  by using function \code{fclust_write()}.
}
\details{
The results are saved in 5 different files.

 \itemize{
 \item \code{"filename.options.csv"}{: contains \code{nbElt}, \code{nbAss},
   \code{nbOpt}, \code{"opt.method"}, \code{"opt.mean"},
   \code{"opt.model"}.}
 \item \code{"filename.inputs.csv"}{: contains \code{fobs} and
  \code{names(fobs)}, \code{xpr} and \code{names(xpr)}.}
 \item \code{"filename.trees.csv"}{: contains the hierarchical tree
   \code{tree$aff} and \code{tree$cor}.}
 \item \code{"filename.matrices.csv"}{: contains the matrices
   \code{mCal}, \code{mPrd}, \code{mMotifs}, \code{tCal}, \code{tPrd},
    and \code{tNbcl}.}
 \item \code{"filename.stats.csv"}{: contains both statistical matrices
 \code{mStats} and \code{tStats}.}
 }

 If only a file does not exist or is corrupted, the function is stopped.
}
\examples{

# save "res" in the files "myRecord.*" then read them again.

res <- CedarCreek.2004.res
filename <- tempfile(pattern = "myRecord", tmpdir = tempdir())

fclust_write(res, filename)
res <- fclust_read(filename)

all.equal(res, CedarCreek.2004.res)


}
\seealso{
\code{\link{fclust}}: make a functional clustering,\cr
\code{\link{fclust_plot}}: plot the results of a functional clustering,\cr
\code{\link{fclust_write}}: save the results of a functional clustering,\cr
\code{\link{fclust_read}}: read the results of a functional clustering.\cr
}
