% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclust.R
\name{check_repeat}
\alias{check_repeat}
\title{Check for identical assemblages}
\usage{
check_repeat(fobs, mOccur, opt.mean = "amean", opt.repeat = FALSE )
}
\arguments{
\item{fobs}{a numeric vector. The vector \code{fobs} contains the
quantitative performances of assemblages.}

\item{mOccur}{a matrix of occurrence (occurrence of elements).
Its first dimension equals to \code{length(fobs)}. Its second dimension
 equals to the number of elements.}

\item{opt.mean}{a character equals to \code{"amean"} or \code{"gmean"}.
Switchs to arithmetic formula if \code{opt.mean = "amean"}.
Switchs to geometric formula if \code{opt.mean = "gmean"}. \cr

Modelled performances are computed
using arithmetic mean (\code{opt.mean = "amean"})
or geometric mean (\code{opt.mean = "gmean"})
according to \code{opt.model}.}

\item{opt.repeat}{a logical.
in any case, the function looks for
different assemblages with identical elemental composition.
Messages indicate these identical assemblages.
If \code{opt.repeat = FALSE} (by default),
their performances are averaged.
If \code{opt.repeat = TRUE}, nothing is done,
and the data are processed as they are.}
}
\value{
Return a list containing:
\itemize{
\code{$fobs}{: the matrix of averaged performances of unique assemblages.}
\code{$mOccur}{: the matrix of occurrence of unique assemblages.}
}
}
\description{
Check if several assemblages
have the same elemental composition,
then average the performances of assemblages
with an identical elemental composition.
}
\details{
None.
}
\keyword{internal}
