% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fclust.R
\name{add_ass_names}
\alias{add_ass_names}
\title{Add assemblage names on a plot}
\usage{
add_ass_names(Fx, Fy, assMotif, cols)
}
\arguments{
\item{Fx, Fy}{two numeric vectors of \code{length(Fx)}.
The first vector contains reference, observed assemblage performances.
The second vector contains assemblage performances
modelled by components clustering.}

\item{assMotif}{an integer vector of \code{length(Fx)}.
The vector contains the labels of each assemblages.
The labels are only used to plot the assemblage performances
that share a same assembly motif
with a same symbol and color.
If it is omitted, all points are plotted using a same symbol and color.
The default symbol and color is \code{"red circle"}.}

\item{cols}{an integer vector of \code{length(Fx)}.
It contains the colours specific to each assembly motif
recorded in \code{assMotif}.}
}
\value{
Nothing. It is a procedure.
}
\description{
Plot the name of each assemblage near its performance
on a graph plotted using the functions
\code{\link{plot_prediction_simple}} or
\code{\link{plot_prediction_LOO}}.
}
\details{
A given assemblage is always plotted
using the same symbol and color.
}
\keyword{internal}
