% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real_time_00_mfd.R
\name{get_mfd_list_real_time}
\alias{get_mfd_list_real_time}
\title{Get a list of functional data objects each evolving up to
an intermediate domain point.}
\usage{
get_mfd_list_real_time(
  data_list,
  grid = NULL,
  n_basis = 30,
  lambda = NULL,
  lambda_grid = 10^seq(-10, 1, length.out = 10),
  k_seq = seq(from = 0.25, to = 1, length.out = 10),
  ncores = 1
)
}
\arguments{
\item{data_list}{See \code{\link{get_mfd_list}}.}

\item{grid}{See \code{\link{get_mfd_list}}.}

\item{n_basis}{See \code{\link{get_mfd_list}}.}

\item{lambda}{See \code{\link{get_mfd_list}}.}

\item{lambda_grid}{See \code{\link{get_mfd_df}}.}

\item{k_seq}{A vector of values between 0 and 1, containing the domain points
over which functional data are to be evaluated in real time.
If the domain is the interval (a,b), for each instant k in the sequence,
functions are evaluated in (a,k(b-a)).}

\item{ncores}{If you want parallelization, give the number of cores/threads
to be used when creating mfd objects separately for different instants.}
}
\value{
A list of \code{mfd} objects as produced by
\code{\link{get_mfd_list}}.
}
\description{
This function produces a list functional data objects,
each evolving up to an intermediate domain point, that can be used to
estimate models that allow real-time predictions of incomplete functions,
from the current functional domain up to the end of the observation,
and to build control charts for real-time  monitoring.

It calls the function \code{\link{get_mfd_list}} for each domain point.
}
\examples{
library(funcharts)
data("air")
# Only take first 5 multivariate functional observations from air
air_small <- lapply(air, function(x) x[1:5, ])
# Consider only 3 domain points: 0.5, 0.75, 1
mfdobj <- get_mfd_list_real_time(data_list = air_small,
                                 lambda = 1e-2,
                                 k_seq = c(0.5, 0.75, 1))

}
\seealso{
\code{\link{get_mfd_list}}
}
