% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funDataClass.R, R/funDataMethods.R, R/names.R,
%   R/str.R, R/summary.R
\docType{class}
\name{irregFunData-class}
\alias{irregFunData-class}
\alias{irregFunData}
\alias{irregFunData,list,list-method}
\alias{show,irregFunData-method}
\alias{names,irregFunData-method}
\alias{names<-,irregFunData-method}
\alias{str,irregFunData-method}
\alias{summary,irregFunData-method}
\title{A class for irregularly sampled functional data}
\usage{
\S4method{irregFunData}{list,list}(argvals, X)

\S4method{show}{irregFunData}(object)

\S4method{names}{irregFunData}(x)

\S4method{names}{irregFunData}(x) <- value

\S4method{str}{irregFunData}(object, ...)

\S4method{summary}{irregFunData}(object, ...)
}
\arguments{
\item{argvals}{A list of numerics, corresponding to the observation points for each realization \eqn{X_i} (see Details).}

\item{X}{A list of numerics, corresponding to the observed functions \eqn{X_i} (see Details).}

\item{object}{An \code{irregFunData} object.}

\item{x}{The \code{irregFunData} object.}

\item{value}{The names to be given to the \code{irregFunData} curves.}

\item{...}{Other parameters passed to \code{summary}.}
}
\description{
The \code{irregFunData} class represents functional data that is sampled 
irregularly on one-dimensional domains. The two slots represent the 
observation points (x-values) and the observed function values (y-values).
}
\details{
Irregular functional data are realizations of a random process \deqn{X: 
\mathcal{T} \to \mathrm{IR},}{X: T -> IR,} where each realization 
\eqn{X_i} of \eqn{X} is given on an individual grid \eqn{T_i \subset 
\mathcal{T}}{T_i \subset T} of observation points. As for the 
\code{\linkS4class{funData}} class, each object of the \code{irregFunData}
class has two slots; the \code{argvals} slot represents the observation
points and the \code{X} slot represents the observed data. In contrast to the
regularly sampled data, both slots are defined as lists of vectors, where
each entry corresponds to one observed function: \itemize{\item
\code{argvals[[i]]} contains the vector of observation points \eqn{T_i} for
the i-th function, \item \code{X[[i]]} contains the corresponding observed
data \eqn{X_i(t_{ij}), t_{ij} \in T_i}.}

Generic functions for the \code{irregFunData} class include a print method, 
\link[=plot.irregFunData]{plotting} and \link[=Arith.funData]{basic 
arithmetics}. Further methods for \code{irregFunData}: \itemize{ \item 
\code{\link{dimSupp}}, \code{\link{nObs}}: Informations about the support 
dimensions and the number of observations, \item \code{\link{getArgvals}}, 
\code{\link{extractObs}}: Getting/setting slot values (instead of accessing 
them directly via \code{irregObject@argvals, irregObject@X}) and extracting
single observations or data on a subset of the domain, \item 
\code{\link{integrate}}, \code{\link{norm}}: Integrate all observations over 
their domain or calculating the \eqn{L^2}{L^2} norm.}

An \code{irregFunData} object can be coerced to a \code{funData} object using
\code{as.funData(irregObject)}. The regular functional data object is defined
on the union of all observation grids of the irregular object. The value of 
the new object is marked as missing (\code{NA}) for observation points that 
are in the union, but not in the original observation grid.
}
\section{Methods (by generic)}{
\itemize{
\item \code{irregFunData}: Constructor for irregular functional data
objects.

\item \code{show}: Print basic information about the \code{irregFunData} object
in the console. The default console output for \code{irregFunData} objects.

\item \code{names}: Get the names of the \code{irregFunData} object.

\item \code{names<-}: Set the names of the \code{irregFunData} object.

\item \code{str}: A \code{str} method for \code{irregFunData} objects, giving a compact overview of the structure.

\item \code{summary}: A \code{summary} method for \code{irregFunData} objects.
}}

\section{Slots}{

\describe{
\item{\code{argvals}}{A list of numerics, representing the observation grid \eqn{T_i}
for each realization \eqn{X_i} of \eqn{X}.}

\item{\code{X}}{A list of numerics, representing the values of each observation 
\eqn{X_i} of \eqn{X} on the corresponding observation points \eqn{T_i}.}
}}

\section{Warning}{
 Currently, the class is implemented only for functional 
  data on one-dimensional domains \eqn{\mathcal{T} \subset \mathrm{IR}}{T
  \subset IR}.
}

\examples{
# Construct an irregular functional data object
i1 <- irregFunData(argvals = list(1:5, 2:4), X = list(2:6, 3:5))
# Display in the console
i1
# Summarize
summary(i1)

# A more realistic object
argvals <- seq(0,2*pi, 0.01)
ind <- replicate(11, sort(sample(1:length(argvals), sample(5:10,1)))) # sample observation points
argvalsIrreg <- lapply(ind, function(i){argvals[i]})
i2 <- irregFunData(argvals = argvalsIrreg, X = mapply(function(x, a){a * sin(x)},
             x = argvalsIrreg, a = seq(0.75, 1.25, by = 0.05)))
# Display/summary gives basic information
i2
summary(i2)
# Use the plot function to get an impression of the data
plot(i2) 
}
\seealso{
\code{\linkS4class{funData}}, \code{\linkS4class{multiFunData}}
}
