% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fslxor.R
\name{fslxor}
\alias{fslxor}
\alias{fsl_xor}
\title{Perform XOR/Exclusive Or operation on Images using FSL}
\usage{
fslxor(file, file2, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, ...)

fsl_xor(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)
}
\arguments{
\item{file}{(character) input image}

\item{file2}{(character) image to be XOR'd}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{reorient}{(logical) If retimg, should file be reoriented 
when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{...}{additional arguments passed to \code{\link{readnii}}.}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslmaths file -add file2 -bin}
after binarizing \code{file} and \code{file2} using
\code{\link{fslbin}} and then uses \code{\link{fsl_thresh}} 
to threshold any values greater than 1 back to zero.
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
