% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probtrackx.R
\name{probtrackx}
\alias{probtrackx}
\title{Probabilistic diffusion tractography with multiple fibre orientations}
\usage{
probtrackx(samples = "merged", mask, seed, verbose = TRUE, out = NULL,
  dir = NULL, forcedir = FALSE, simple = NULL, network = FALSE,
  opd = NULL, pd = FALSE, fopd = NULL, os2t = FALSE, s2tastext = NULL,
  targetmasks = NULL, waypoints = NULL, waycond = c("AND", "OR"),
  wayorder = NULL, onewaycondition = FALSE, avoid = NULL, stop = NULL,
  omatrix1 = NULL, distthresh1 = NULL, omatrix2 = NULL, target2 = NULL,
  omatrix3 = NULL, target3 = NULL, lrtarget3 = NULL, distthresh3 = 0,
  xfm = NULL, invxfm = NULL, seedref = NULL, meshspace = c("caret",
  "freesurfer", "first", "vox"), nsamples = 5000, nsteps = 2000,
  steplength = 0.5, distthresh = 0, cthr = 0.2, fibthresh = 0.01,
  loopcheck = FALSE, usef = FALSE, modeuler = FALSE, sampvox = 0,
  randfib = 0, fibst = 1, rseed = NULL, ...)
}
\arguments{
\item{samples}{Basename for samples files - e.g. 'merged'}

\item{mask}{Bet binary mask file in diffusion space}

\item{seed}{Seed volume or list (ascii text file) of volumes and/or surfaces}

\item{verbose}{Verbose level, [0-2]}

\item{out}{Output file (default='fdt_paths')}

\item{dir}{Directory to put the final volumes in - code makes this directory - default='logdir'}

\item{forcedir}{Use the actual directory name given - i.e. don't add + to make a new directory}

\item{simple}{Track from a list of voxels (seed must be a ASCII list of coordinates)}

\item{network}{Activate network mode - only keep paths going through at least one of the other seed masks}

\item{opd}{Output path distribution}

\item{pd}{Correct path distribution for the length of the pathways}

\item{fopd}{Other mask for binning tract distribution}

\item{os2t}{Output seeds to targets}

\item{s2tastext}{Output seed-to-target counts as a text file (default in simple mode)}

\item{targetmasks}{File containing a list of target masks - for seeds_to_targets classification}

\item{waypoints}{Waypoint mask or ascii list of waypoint masks - only keep paths going through ALL the masks}

\item{waycond}{Waypoint condition. Either 'AND' (default) or 'OR'}

\item{wayorder}{Reject streamlines that do not hit waypoints in given order. Only valid if waycond=AND}

\item{onewaycondition}{Apply waypoint conditions to each half tract separately}

\item{avoid}{Reject pathways passing through locations given by this mask}

\item{stop}{Stop tracking at locations given by this mask file}

\item{omatrix1}{Output matrix1 - SeedToSeed Connectivity}

\item{distthresh1}{Discards samples (in matrix1) shorter than this threshold (in mm - default=0)}

\item{omatrix2}{Output matrix2 - SeedToLowResMask}

\item{target2}{Low resolution binary brain mask for storing connectivity distribution in matrix2 mode}

\item{omatrix3}{Output matrix3 (NxN connectivity matrix)}

\item{target3}{Mask used for NxN connectivity matrix (or Nxn if lrtarget3 is set)}

\item{lrtarget3}{Column-space mask used for Nxn connectivity matrix}

\item{distthresh3}{Discards samples (in matrix3) shorter than this threshold (in mm - default=0)}

\item{xfm}{Transform taking seed space to DTI space (either FLIRT matrix or FNIRT warpfield) - default is identity}

\item{invxfm}{Transform taking DTI space to seed space (compulsory when using a warpfield for seeds_to_dti)}

\item{seedref}{Reference vol to define seed space in simple mode - diffusion space assumed if absent}

\item{meshspace}{Mesh reference space - either 'caret' (default) or 'freesurfer' or 'first' or 'vox'}

\item{nsamples}{Number of samples - default=5000}

\item{nsteps}{Number of steps per sample - default=2000}

\item{steplength}{Steplength in mm - default=0.5}

\item{distthresh}{Discards samples shorter than this threshold (in mm - default=0)}

\item{cthr}{Curvature threshold - default=0.2}

\item{fibthresh}{Volume fraction before subsidary fibre orientations are considered - default=0.01}

\item{loopcheck}{Perform loopchecks on paths - slower, but allows lower curvature threshold}

\item{usef}{Use anisotropy to constrain tracking}

\item{modeuler}{Use modified euler streamlining}

\item{sampvox}{Sample random points within x mm sphere seed voxels (e.g. --sampvox=5). Default=0}

\item{randfib}{Default 0. Set to 1 to randomly sample initial fibres (with f > fibthresh).  Set to 2 to sample in proportion fibres (with f>fibthresh) to f.  Set to 3 to sample ALL populations at random (even if f<fibthresh)}

\item{fibst}{Force a starting fibre for tracking - default=1, i.e. first fibre orientation. Only works if randfib==0}

\item{rseed}{Random seed}

\item{...}{Additional arguments}
}
\description{
This function wraps \code{probtrackx2} from FSL
}

