% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg_stats.R
\name{qc.from.segstats.tables}
\alias{qc.from.segstats.tables}
\title{Perform data quality check based on a segstats table.}
\usage{
qc.from.segstats.tables(filepath_lh, filepath_rh, ...)
}
\arguments{
\item{filepath_lh}{path to left hemisphere input file, a tab-separated file generated by running the FreeSurfer tools 'aparcstats2table' or 'asegstats2table'. The command line in the system shell would be something like 'aparcstats2table_bin --subjectsfile $subjects_file --meas $measure --hemi $hemi -t $aparc_output_table'.}

\item{filepath_rh}{path to equivalent right hemisphere input file.}

\item{...}{parameters passed to \code{\link[fsbrain]{qc.from.regionwise.df}}.}
}
\value{
qc result as a hemilist, each entry contains a named list as returned by \code{\link[fsbrain]{qc.from.regionwise.df}}.
}
\description{
Determine subjects that potentially failed segmentation, based on segstats table data. The input table file must be a segmentation or parcellation table, generated by running the FreeSurfer tools 'aparcstats2table' or 'asegstats2table' for your subjects.
}
