% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brain_igraph.R
\name{fs.surface.vertex.neighbors}
\alias{fs.surface.vertex.neighbors}
\title{Compute vertex neighborhoods or the full adjacency list for a mesh using the Rvcg or igraph library.}
\usage{
fs.surface.vertex.neighbors(
  surface,
  nodes = NULL,
  order = 1L,
  simplify = TRUE,
  include_self = FALSE
)
}
\arguments{
\item{surface}{an fs.surface instance as returned by \code{subject.surface}, an existing igraph (which will be returned as-is) or a string which is interpreted as a path to a surface file.}

\item{nodes}{the source vertex. Passed on to \code{igraph::neighborhood}. Can be a vector, in which case the neighborhoods for all these vertices are computed separately. If NULL, all graph vertices are used.}

\item{order}{integer, the max graph distance of vertices to consider neighbors (number of neighborhood rings). Passed on to \code{igraph::neighborhood}}

\item{simplify}{logical, whether to return only an integer vector if the 'nodes' parameter has length 1 (instead of a list where the first element is such a vector).}

\item{include_self}{logical, whether to include vertices in their own neighborhood}
}
\value{
named list of integer vectors (see \code{igraph::neighborhood}), unless 'simplify' is TRUE, see there for details.
}
\description{
This is a faster replacement for \code{mesh.vertex.neighbors} that requires the optional dependency package 'igraph' or 'Rvcg'.
}
\note{
If you intend to call several functions on the igraph, it is faster to construct it with \code{fs.surface.to.igraph} and keep it.
}
\seealso{
The \code{fs.surface.as.adjacencylist} function computes the 1-ring neighborhood for the whole graph.
}
