% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodesic.R
\name{geod.patches.color.overlay}
\alias{geod.patches.color.overlay}
\title{Generate color overlay from geodesic patches around several vertices.}
\usage{
geod.patches.color.overlay(
  mesh,
  vertex,
  color = "#FF0000",
  bg_color = "#FEFEFE",
  ...
)
}
\arguments{
\item{mesh}{a single \code{fs.surface} instance, or a \code{\link[fsbrain]{hemilist}} of two such meshes. If a hemilist, the vertex indices can go from 1 to the sum of vertices in both meshes, and the proper hemisphere will be used automatically.}

\item{vertex}{positive integer (or vector of the latter), the index of the source vertex in the mesh. If a vector, the neighborhoods for all vertices will be computed separately.}

\item{color}{single color string like \code{'#FF0000'} or vector of such strings. If a vector, the length should match the number of vertices in parameter 'vertex'.}

\item{bg_color}{character string, the background color.}

\item{...}{extra arguments passed to \code{geod.vert.neighborhood}.}
}
\value{
vector of color strings (or a \code{\link[fsbrain]{hemilist}} of 2 such vectors if 'mesh' is a hemilist), an overlay suitable for visualization using \code{vis.color.on.subject}.
}
\description{
Works across hemispheres (for a whole brain) if you pass a \code{\link[fsbrain]{hemilist}} of meshes as parameter 'mesh', see below.
}
\examples{
\dontrun{
  sjd = fsaverage.path(TRUE);
  surfaces = subject.surface(sjd, 'fsaverage', surface = "white", hemi = "both");
  colors = geod.patches.color.overlay(surfaces, vertex = c(12345L, 45L),
    color = c("#FF0000", "#00FF00"), max_distance = 45.0);
  vis.color.on.subject(sjd, 'fsaverage', color_lh=colors$lh, color_rh=colors$rh);
}

}
