% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbar.R
\name{vis.colortable.legend}
\alias{vis.colortable.legend}
\title{Create a separate legend plot for a colortable or an annotation.}
\usage{
vis.colortable.legend(colortable, ncols = 1L, plot_struct_index = TRUE)
}
\arguments{
\item{colortable}{dataframe, a colortable as returned by \code{\link[freesurferformats]{read.fs.colortable}} or the inner 'colortable_df' returned by \code{\link[fsbrain]{subject.annot}}. One can also pass an annotation (*fs.annot* instance).}

\item{ncols}{positive integer, the number of columns to use when plotting}

\item{plot_struct_index}{logical, whether to plot the region index from tge 'struct_index' field. If there is no such field, this is silently ignored.}
}
\description{
This plots a legend for a colortable or an atlas (annotation), showing the region names and their assigned colors. This function creates a new plot.
}
\note{
This function plots one or more legends (see \code{\link[graphics]{legend}}). You may have to adapt the device size before calling this function if you inted to plot a large colortable.
}
\examples{
\dontrun{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   annot = subject.annot(subjects_dir, 'subject1', 'lh', 'aparc');
   vis.colortable.legend(annot$colortable_df, ncols=3);
}

}
