% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_io.R
\name{qdec.table.skeleton}
\alias{qdec.table.skeleton}
\title{Generate skeleton dataframe for FreeSurfer QDEC long file from subjects list.}
\usage{
qdec.table.skeleton(
  subjects_list,
  isi = rep(0.8, length(subjects_list)),
  isi_name = "years",
  timepoint_names = c("_MR1", "_MR2")
)
}
\arguments{
\item{subjects_list}{vector of character strings, the Freesurfer subject IDs (cross-sectional names, without any suffixes like \code{_MR1, long,} etc.)}

\item{isi}{numerical vector, the inter-scan interval for the subjects, in a unit of your choice. Typically in years.}

\item{isi_name}{character string, the name for the isi columns. Defaults to "years".}

\item{timepoint_names}{vector of character strings, the timepoint names. These are mandatory for QDEC, so there should be very little reason to change them. Leave along unless you know what you are doing.}
}
\value{
data.frame with 3 columns named fsid and fsid-base and 'isi_name', a data.frame to use with the \code{\link{demographics.to.qdec.table.dat}} function.
}
\description{
Generate skeleton dataframe for FreeSurfer QDEC long file from subjects list.
}
\examples{
    dem = data.frame("ID"=paste("subject", seq(5), sep=""),
      "age"=sample.int(20, 5)+10L, "isi"=rnorm(5, 2.0, 0.1)); #sample data.
    qdec.table.skeleton(dem$ID, dem$isi);

}
\seealso{
The function \code{\link{demographics.to.qdec.table.dat}} to write the result to a QDEC file.
}
