% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coloredmesh.R
\name{coloredmeshes.from.color}
\alias{coloredmeshes.from.color}
\title{Create coloredmeshes for both hemis using pre-defined colors.}
\usage{
coloredmeshes.from.color(
  subjects_dir,
  subject_id,
  color_data,
  hemi,
  surface = "white",
  metadata = list()
)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier.}

\item{color_data}{a hemilist containing vectors of hex color strings}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the label data files to be loaded.}

\item{surface}{character string or `fs.surface` instance. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{metadata}{a named list, can contain whatever you want. Typical entries are: 'src_data' a hemilist containing the source data from which the 'color_data' was created, optional. If available, it is encoded into the coloredmesh and can be used later to plot a colorbar. 'makecmap_options': the options used to created the colormap from the data.}
}
\value{
named list of coloredmeshes. Each entry is a named list with entries: "mesh" the \code{\link{tmesh3d}} mesh object. "col": the mesh colors. "render", logical, whether to render the mesh. "hemi": the hemisphere, one of 'lh' or 'rh'.
}
\description{
Create coloredmeshes for both hemis using pre-defined colors.
}
\seealso{
Other coloredmesh functions: 
\code{\link{coloredmesh.from.annot}()},
\code{\link{coloredmesh.from.label}()},
\code{\link{coloredmesh.from.mask}()},
\code{\link{coloredmesh.from.morph.native}()},
\code{\link{coloredmesh.from.morph.standard}()},
\code{\link{coloredmesh.from.morphdata}()}
}
\concept{coloredmesh functions}
