% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hemilist.R
\name{hemilist.wrap}
\alias{hemilist.wrap}
\title{Wrap data into a named hemi list.}
\usage{
hemilist.wrap(data, hemi, hemilist = NULL)
}
\arguments{
\item{data}{something to wrap, typically some data for a hemisphere, e.g., a vector of morphometry data values. If NULL, the name will not be created.}

\item{hemi}{character string, one of 'lh' or 'rh'. The name to use for the data in the returned list.}

\item{hemilist}{optional hemilist, an existing hemilist to add the entry to. If left at the default value `NULL`, a new list will be created.}
}
\value{
named list, with the 'data' in the name given by parameter 'hemi'
}
\description{
Wrap data into a named hemi list.
}
\seealso{
Other hemilist functions: 
\code{\link{hemilist.derive.hemi}()},
\code{\link{hemilist.get.combined.data}()},
\code{\link{hemilist.unwrap}()},
\code{\link{hemilist}()},
\code{\link{is.hemilist}()}
}
\concept{hemilist functions}
