% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_group.R
\name{vis.data.on.group.standard}
\alias{vis.data.on.group.standard}
\title{Visualize standard space data for a group on template.}
\usage{
vis.data.on.group.standard(
  subjects_dir,
  vis_subject_id,
  morph_data_both,
  captions = NULL,
  view_angles = "sd_dorsal",
  output_img = "fsbrain_group_morph.png",
  num_per_row = 5L,
  rglactions = list(no_vis = TRUE),
  ...
)
}
\arguments{
\item{subjects_dir}{character string, the path to the SUBJECTS_DIR containing the template subject}

\item{vis_subject_id}{character string, the template subject name. A typical choice is 'fsaverage'.}

\item{morph_data_both}{named list of numerical vectors, 4D array or dataframe, the morph data for both hemispheres of all subjects. Can be loaded with \code{\link{group.morph.standard}} or \code{\link{group.morph.standard.sf}}.}

\item{captions}{optional vector of character strings, the short text annotations for the individual tiles. Typically used to plot the subject identifier.}

\item{view_angles}{see \code{\link{get.view.angle.names}}.}

\item{output_img}{character string, the file path for the output image. Should end with '.png'.}

\item{num_per_row}{positive integer, the number of tiles per row.}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action. The following example clips outliers in the data before plotting and writes a screenshot in PNG format: \code{rglactions = list("snapshot_png"="~/fsbrain.png", "clip_data"=c(0.05, 0.95))}. See \code{\link{rglactions}}.}

\item{...}{extra parameters passed to the subject level visualization function. Not all may make sense in this context. Example: \code{surface='pial'}.}
}
\value{
named list, see the return value of \code{\link{arrange.brainview.images.grid}} for details.
}
\description{
Plot standard space data for a group of subjects onto a template brain and combine the tiles into a single large image.
}
\note{
The subject data are plotted row-wise, in the order in which they appear in the 'morph_data_both' parameter.

You can force an identical plot range for all subjects, so that one color represents identical values across subjects, via 'makecmap_options'. E.g., for the ... parameter, pass \code{makecmap_options=list('colFn'=viridis::viridis, 'range'=c(0, 4)))}.
}
\seealso{
Other group visualization functions: 
\code{\link{vis.data.on.group.native}()},
\code{\link{vis.group.annot}()},
\code{\link{vis.group.coloredmeshes}()},
\code{\link{vis.group.morph.native}()},
\code{\link{vis.group.morph.standard}()}
}
\concept{group visualization functions}
