% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbar_magick.R
\name{combine.colorbar.with.brainview.image}
\alias{combine.colorbar.with.brainview.image}
\title{Combine a colorbar and a brainview image into a new figure.}
\usage{
combine.colorbar.with.brainview.image(
  brainview_img,
  colorbar_img,
  output_img,
  offset = "+0+0",
  extend_brainview_img_height_by = 0L,
  silent = FALSE,
  allow_colorbar_shrink = TRUE
)
}
\arguments{
\item{brainview_img}{path to the main image containing the view of the brain, usually an image in PNG format}

\item{colorbar_img}{path to the main image containing the separate colorbar, usually an image in PNG format}

\item{output_img}{path to output image that including the file extension}

\item{offset}{offset string passed to \code{\link[magick]{image_composite}}. Allows you to shift the location of the colorbar in the final image.}

\item{extend_brainview_img_height_by}{integer value in pixels, the size of the lower border to add to the brainview_img. Use this if the lower part of the colorbar is off the image canvas.}

\item{silent}{logical, whether to silence all messages}

\item{allow_colorbar_shrink}{logical, whether to shrink the colorbar to the width of the animation in case it is considerably wider (more than 20 percent). Defaults to TRUE.}
}
\description{
Combine a colorbar and a brainview image into a new figure.
}
\seealso{
Other colorbar functions: 
\code{\link{coloredmesh.plot.colorbar.separate}()},
\code{\link{combine.colorbar.with.brainview.animation}()}
}
\concept{colorbar functions}
