% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.labeldata.on.subject}
\alias{vis.labeldata.on.subject}
\title{Visualize a label on the surface of a subject.}
\usage{
vis.labeldata.on.subject(subjects_dir, vis_subject_id, lh_labeldata,
  rh_labeldata, surface = "white", colormap = squash::rainbow2,
  views = c("t4"), rgloptions = list(), rglactions = list(),
  draw_colorbar = FALSE)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, containing the subdir of vis_subject_id, the subject that you want to use for visualization.}

\item{vis_subject_id, }{string The subject identifier from which to obtain the surface for data visualization. Example: 'fsaverage'.}

\item{lh_labeldata}{integer vector of vertex indices for the left hemisphere}

\item{rh_labeldata}{integer vector of vertex indices for the right hemisphere}

\item{surface}{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap}{a colormap. See the squash package for some colormaps. Defaults to \code{\link[squash]{jet}}.}

\item{views}{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to \code{\link[rgl]{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))}}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. The values can be used to specify parameters for the action.}

\item{draw_colorbar}{logical, whether to draw a colorbar. WARNING: The colorbar is drawn to a subplot, and this only works if there is enough space for it. You will have to increase the plot size using the 'rlgoptions' parameter for the colorbar to show up. Defaults to FALSE. See \code{\link[fsbrain]{coloredmesh.plot.colorbar.separate}} for an alternative.}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Visualizes a label. Note that a label is just a set of vertices, and that you can use this function to visualize sets of vertices, e.g., to see where on the mesh a certain vertex lies. It may be helpful the visualize the vertex with its neighbors, because otherwise it may be too small to spot. Use the function [fsbrain::mesh.vertex.neighbors] to get them. It is advisable to set the view to the interactive 'si' mode and use the 'inflated' surface to identify single vertices.
}
\examples{
\donttest{
   fsbrain::download_optional_data();

  # Define the data to use:
  subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
  lh_labeldata = c(1000, 1001, 1002);   # only the vertices, will be tiny.
  subject_id = 'subject1';
  surface = 'white'; # Should use 'inflated', but we do not currently
                     # ship it for the example subject to reduce download size.

  # For the right hemi, extend them to neighborhood for better visibility:
  rh_labeldata = c(500, 5000);
  rh_surface = subject.surface(subjects_dir, subject_id, surface, 'rh');
  rh_labeldata_neighborhood = mesh.vertex.neighbors(rh_surface, rh_labeldata);
  vis.labeldata.on.subject(subjects_dir, subject_id, lh_labeldata,
   rh_labeldata_neighborhood$vertices, surface=surface, views=c('si'));
}

}
\seealso{
Other label functions: \code{\link{apply.label.to.morphdata}},
  \code{\link{apply.labeldata.to.morphdata}},
  \code{\link{vis.subject.label}}

Other visualization functions: \code{\link{vis.data.on.fsaverage}},
  \code{\link{vis.data.on.subject}},
  \code{\link{vis.mask.on.subject}},
  \code{\link{vis.region.values.on.subject}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.label}},
  \code{\link{vis.subject.morph.native}},
  \code{\link{vis.subject.morph.standard}},
  \code{\link{vislayout.from.coloredmeshes}}
}
\concept{label functions}
\concept{visualization functions}
