% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsdir_abstraction_subject.R
\name{subject.surface}
\alias{subject.surface}
\title{Load a surface for a subject.}
\usage{
subject.surface(subjects_dir, subject_id, surface, hemi)
}
\arguments{
\item{subjects_dir}{string. The FreeSurfer SUBJECTS_DIR, i.e., a directory containing the data for all your subjects, each in a subdir named after the subject identifier.}

\item{subject_id}{string. The subject identifier}

\item{surface}{string. The surface name. E.g., "white", or "pial". Used to construct the name of the surface file to be loaded.}

\item{hemi}{string, one of 'lh' or 'rh'. The hemisphere name. Used to construct the names of the surface file to be loaded.}
}
\value{
the surface, as returned by freesurferformats::read.fs.surface(). A named list containing entries 'vertices' and 'faces'.
}
\description{
Load a brain surface for a subject.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   lh_white = subject.surface(subjects_dir, "subject1", "white", "lh");
}

}
\seealso{
Other surface mesh functions: \code{\link{mesh.vertex.neighbors}}
}
\concept{surface mesh functions}
